/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bootstrap;

import com.google.inject.Inject;
import io.airlift.bootstrap.Executed;
import io.airlift.bootstrap.TestLifeCycleManager;
import java.util.concurrent.CountDownLatch;

public class ExecutedInstance
extends Executed {
    private final CountDownLatch startLatch = new CountDownLatch(1);
    private final CountDownLatch endLatch = new CountDownLatch(1);

    @Inject
    public ExecutedInstance() {
    }

    public void waitForStart() throws InterruptedException {
        this.startLatch.await();
    }

    public void waitForEnd() throws InterruptedException {
        this.endLatch.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        TestLifeCycleManager.note("Starting");
        this.startLatch.countDown();
        try {
            if (!Thread.interrupted()) {
                try {
                    Thread.sleep(Integer.MAX_VALUE);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        finally {
            TestLifeCycleManager.note("Done");
            this.endLatch.countDown();
        }
    }
}

