/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bootstrap;

import com.google.common.collect.Lists;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.bootstrap.LifeCycleMethods;
import io.airlift.bootstrap.LifeCycleMethodsMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

public class LifeCycleModule
implements Module {
    private final List<Object> injectedInstances = Lists.newArrayList();
    private final LifeCycleMethodsMap lifeCycleMethodsMap = new LifeCycleMethodsMap();
    private final AtomicReference<LifeCycleManager> lifeCycleManagerRef = new AtomicReference<Object>(null);

    public void configure(Binder binder) {
        binder.requireExplicitBindings();
        binder.disableCircularProxies();
        binder.bindListener(Matchers.any(), new TypeListener(){

            public <T> void hear(TypeLiteral<T> type, TypeEncounter<T> encounter) {
                encounter.register(new InjectionListener<T>(){

                    public void afterInjection(T obj) {
                        if (LifeCycleModule.this.isLifeCycleClass(obj.getClass())) {
                            LifeCycleManager lifeCycleManager = (LifeCycleManager)LifeCycleModule.this.lifeCycleManagerRef.get();
                            if (lifeCycleManager != null) {
                                try {
                                    lifeCycleManager.addInstance(obj);
                                }
                                catch (Exception e) {
                                    throw new Error(e);
                                }
                            } else {
                                LifeCycleModule.this.injectedInstances.add(obj);
                            }
                        }
                    }
                });
            }
        });
    }

    @Provides
    @Singleton
    public LifeCycleManager getServerManager() throws Exception {
        LifeCycleManager lifeCycleManager = new LifeCycleManager(this.injectedInstances, this.lifeCycleMethodsMap);
        this.lifeCycleManagerRef.set(lifeCycleManager);
        return lifeCycleManager;
    }

    private boolean isLifeCycleClass(Class<?> clazz) {
        LifeCycleMethods methods = this.lifeCycleMethodsMap.get(clazz);
        return methods.hasFor(PostConstruct.class) || methods.hasFor(PreDestroy.class);
    }
}

