/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bootstrap;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Stage;
import io.airlift.bootstrap.ColumnPrinter;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.bootstrap.LifeCycleModule;
import io.airlift.bootstrap.LoggingWriter;
import io.airlift.configuration.ConfigurationAwareModule;
import io.airlift.configuration.ConfigurationFactory;
import io.airlift.configuration.ConfigurationInspector;
import io.airlift.configuration.ConfigurationLoader;
import io.airlift.configuration.ConfigurationModule;
import io.airlift.configuration.ConfigurationValidator;
import io.airlift.configuration.ValidationErrorModule;
import io.airlift.configuration.WarningsMonitor;
import io.airlift.jmx.JmxInspector;
import io.airlift.log.Logger;
import io.airlift.log.Logging;
import io.airlift.log.LoggingConfiguration;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Bootstrap {
    private final Logger log = Logger.get(Bootstrap.class);
    private final Module[] modules;
    private boolean strictConfig = false;
    private static final String COMPONENT_COLUMN = "COMPONENT";
    private static final String ATTRIBUTE_NAME_COLUMN = "ATTRIBUTE";
    private static final String PROPERTY_NAME_COLUMN = "PROPERTY";
    private static final String DEFAULT_VALUE_COLUMN = "DEFAULT";
    private static final String CURRENT_VALUE_COLUMN = "RUNTIME";
    private static final String DESCRIPTION_COLUMN = "DESCRIPTION";
    private static final String CLASS_NAME_COLUMN = "NAME";
    private static final String OBJECT_NAME_COLUMN = "METHOD/ATTRIBUTE";
    private static final String TYPE_COLUMN = "TYPE";

    public Bootstrap(Module ... modules) {
        this.modules = modules;
    }

    public Bootstrap strictConfig() {
        this.strictConfig = true;
        return this;
    }

    public Injector initialize() throws Exception {
        Logging logging = new Logging();
        Thread.currentThread().setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                Bootstrap.this.log.error(e, "Uncaught exception in thread %s", new Object[]{t.getName()});
            }
        });
        this.log.info("Loading configuration", new Object[0]);
        ConfigurationLoader loader = new ConfigurationLoader();
        Map configFileProperties = Collections.emptyMap();
        String configFile = System.getProperty("config");
        if (configFile != null) {
            configFileProperties = loader.loadPropertiesFrom(configFile);
        }
        TreeMap properties = Maps.newTreeMap();
        properties.putAll(configFileProperties);
        properties.putAll(loader.getSystemProperties());
        properties = ImmutableSortedMap.copyOf((Map)properties);
        ConfigurationFactory configurationFactory = new ConfigurationFactory((Map)properties);
        this.log.info("Initializing logging", new Object[0]);
        LoggingConfiguration configuration = (LoggingConfiguration)configurationFactory.build(LoggingConfiguration.class);
        logging.initialize(configuration);
        final WarningsMonitor warningsMonitor = new WarningsMonitor(){

            public void onWarning(String message) {
                Bootstrap.this.log.warn(message, new Object[0]);
            }
        };
        for (Module module : this.modules) {
            if (!(module instanceof ConfigurationAwareModule)) continue;
            ConfigurationAwareModule configurationAwareModule = (ConfigurationAwareModule)module;
            configurationAwareModule.setConfigurationFactory(configurationFactory);
        }
        ConfigurationValidator configurationValidator = new ConfigurationValidator(configurationFactory, warningsMonitor);
        List messages = configurationValidator.validate(this.modules);
        final TreeMap unusedProperties = Maps.newTreeMap();
        unusedProperties.putAll(configFileProperties);
        unusedProperties.keySet().removeAll(configurationFactory.getUsedProperties());
        this.logConfiguration(configurationFactory, unusedProperties);
        ImmutableList.Builder moduleList = ImmutableList.builder();
        moduleList.add((Object)new LifeCycleModule());
        moduleList.add((Object)new ConfigurationModule(configurationFactory));
        if (!messages.isEmpty()) {
            moduleList.add((Object)new ValidationErrorModule(messages));
        }
        moduleList.add((Object)new Module(){

            public void configure(Binder binder) {
                binder.bind(WarningsMonitor.class).toInstance((Object)warningsMonitor);
            }
        });
        moduleList.add((Object)new Module(){

            public void configure(Binder binder) {
                binder.disableCircularProxies();
                binder.requireExplicitBindings();
            }
        });
        if (this.strictConfig) {
            moduleList.add((Object)new Module(){

                public void configure(Binder binder) {
                    for (Map.Entry unusedProperty : unusedProperties.entrySet()) {
                        binder.addError("Configuration property '%s=%s' was not used", new Object[]{unusedProperty.getKey(), unusedProperty.getValue()});
                    }
                }
            });
        }
        moduleList.add((Object[])this.modules);
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Iterable)moduleList.build());
        LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        this.logJMX(injector);
        if (lifeCycleManager.size() > 0) {
            lifeCycleManager.start();
        }
        return injector;
    }

    private void logConfiguration(ConfigurationFactory configurationFactory, Map<String, String> unusedProperties) {
        ColumnPrinter columnPrinter = this.makePrinterForConfiguration(configurationFactory);
        PrintWriter out = new PrintWriter(new LoggingWriter(this.log, LoggingWriter.Type.INFO));
        columnPrinter.print(out);
        out.flush();
        if (!unusedProperties.isEmpty()) {
            this.log.warn("UNUSED PROPERTIES", new Object[0]);
            for (Map.Entry<String, String> unusedProperty : unusedProperties.entrySet()) {
                this.log.warn("%s=%s", new Object[]{unusedProperty.getKey(), unusedProperty.getValue()});
            }
            this.log.warn("", new Object[0]);
        }
    }

    private void logJMX(Injector injector) throws Exception {
        ColumnPrinter columnPrinter = this.makePrinterForJMX(injector);
        PrintWriter out = new PrintWriter(new LoggingWriter(this.log, LoggingWriter.Type.INFO));
        columnPrinter.print(out);
        out.flush();
    }

    private ColumnPrinter makePrinterForJMX(Injector injector) throws Exception {
        JmxInspector inspector = new JmxInspector(injector);
        ColumnPrinter columnPrinter = new ColumnPrinter();
        columnPrinter.addColumn(CLASS_NAME_COLUMN);
        columnPrinter.addColumn(OBJECT_NAME_COLUMN);
        columnPrinter.addColumn(TYPE_COLUMN);
        columnPrinter.addColumn(DESCRIPTION_COLUMN);
        for (JmxInspector.InspectorRecord record : inspector) {
            columnPrinter.addValue(CLASS_NAME_COLUMN, record.className);
            columnPrinter.addValue(OBJECT_NAME_COLUMN, record.objectName);
            columnPrinter.addValue(TYPE_COLUMN, record.type.name().toLowerCase());
            columnPrinter.addValue(DESCRIPTION_COLUMN, record.description);
        }
        return columnPrinter;
    }

    private ColumnPrinter makePrinterForConfiguration(ConfigurationFactory configurationFactory) {
        ConfigurationInspector configurationInspector = new ConfigurationInspector();
        ColumnPrinter columnPrinter = new ColumnPrinter();
        columnPrinter.addColumn(COMPONENT_COLUMN);
        columnPrinter.addColumn(ATTRIBUTE_NAME_COLUMN);
        columnPrinter.addColumn(PROPERTY_NAME_COLUMN);
        columnPrinter.addColumn(DEFAULT_VALUE_COLUMN);
        columnPrinter.addColumn(CURRENT_VALUE_COLUMN);
        columnPrinter.addColumn(DESCRIPTION_COLUMN);
        for (ConfigurationInspector.ConfigRecord record : configurationInspector.inspect(configurationFactory)) {
            String componentName = this.getComponentName(record);
            for (ConfigurationInspector.ConfigAttribute attribute : record.getAttributes()) {
                columnPrinter.addValue(COMPONENT_COLUMN, componentName);
                columnPrinter.addValue(ATTRIBUTE_NAME_COLUMN, attribute.getAttributeName());
                columnPrinter.addValue(PROPERTY_NAME_COLUMN, attribute.getPropertyName());
                columnPrinter.addValue(DEFAULT_VALUE_COLUMN, attribute.getDefaultValue());
                columnPrinter.addValue(CURRENT_VALUE_COLUMN, attribute.getCurrentValue());
                columnPrinter.addValue(DESCRIPTION_COLUMN, attribute.getDescription());
            }
        }
        return columnPrinter;
    }

    private String getComponentName(ConfigurationInspector.ConfigRecord<?> record) {
        Key key = record.getKey();
        String componentName = "";
        if (key.getAnnotationType() != null) {
            componentName = "@" + key.getAnnotationType().getSimpleName() + " ";
        }
        componentName = componentName + key.getTypeLiteral();
        return componentName;
    }
}

