/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bootstrap;

import com.google.inject.Binder;
import com.google.inject.CreationException;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.name.Names;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.Config;
import java.lang.annotation.Annotation;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestConfigurationAwareModule {
    @Test
    public void testConfigAvailable() {
        Injector injector = new Bootstrap(new Module[]{new FooModule()}).strictConfig().doNotInitializeLogging().setRequiredConfigurationProperty("foo.enabled", "true").setRequiredConfigurationProperty("bar.enabled", "true").initialize();
        Assert.assertEquals((String)((String)injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"foo")))), (String)"fooInstance");
        Assert.assertEquals((String)((String)injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"bar")))), (String)"barInstance");
        Assert.assertEquals((String)((String)injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"abc")))), (String)"abcInstance");
    }

    @Test
    public void testInvalidInstall() {
        Bootstrap bootstrap = new Bootstrap(new Module[]{new BrokenInstallModule()}).strictConfig().doNotInitializeLogging();
        Assertions.assertThatThrownBy(() -> ((Bootstrap)bootstrap).initialize()).isInstanceOfSatisfying(CreationException.class, e -> {
            IterableAssert cfr_ignored_0 = (IterableAssert)Assertions.assertThat((Iterable)e.getErrorMessages()).hasOnlyOneElementSatisfying(m -> {
                AbstractStringAssert cfr_ignored_0 = (AbstractStringAssert)Assertions.assertThat((String)m.getMessage()).endsWith((CharSequence)"Use super.install() for ConfigurationAwareModule, not binder.install()");
            });
        });
    }

    public static class BarConfig {
        private boolean bar;

        public boolean isBar() {
            return this.bar;
        }

        @Config(value="bar.enabled")
        public BarConfig setBar(boolean bar) {
            this.bar = bar;
            return this;
        }
    }

    public static class FooConfig {
        private boolean foo;

        public boolean isFoo() {
            return this.foo;
        }

        @Config(value="foo.enabled")
        public FooConfig setFoo(boolean foo) {
            this.foo = foo;
            return this;
        }
    }

    public static class BrokenInstallModule
    extends AbstractConfigurationAwareModule {
        protected void setup(Binder binder) {
            binder.install((Module)new FooModule());
        }
    }

    public static class AbcModule
    implements Module {
        public void configure(Binder binder) {
            binder.bind(String.class).annotatedWith((Annotation)Names.named((String)"abc")).toInstance((Object)"abcInstance");
        }
    }

    public static class BarModule
    extends AbstractConfigurationAwareModule {
        protected void setup(Binder binder) {
            Assert.assertTrue((boolean)((BarConfig)this.buildConfigObject(BarConfig.class)).isBar());
            binder.bind(String.class).annotatedWith((Annotation)Names.named((String)"bar")).toInstance((Object)"barInstance");
        }
    }

    public static class FooModule
    extends AbstractConfigurationAwareModule {
        protected void setup(Binder binder) {
            Assert.assertTrue((boolean)((FooConfig)this.buildConfigObject(FooConfig.class)).isFoo());
            this.install((Module)new BarModule());
            binder.bind(String.class).annotatedWith((Annotation)Names.named((String)"foo")).toInstance((Object)"fooInstance");
            binder.install((Module)new AbcModule());
        }
    }
}

