/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bootstrap;

import com.google.common.base.Preconditions;
import io.airlift.bootstrap.LifeCycleMethods;
import io.airlift.bootstrap.LifeCycleMethodsMap;
import io.airlift.bootstrap.LifeCycleStartException;
import io.airlift.bootstrap.LifeCycleStopException;
import io.airlift.log.Logger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

public final class LifeCycleManager {
    private final Logger log = Logger.get(this.getClass());
    private final AtomicReference<State> state = new AtomicReference<State>(State.LATENT);
    private final Queue<Object> managedInstances = new ConcurrentLinkedQueue<Object>();
    private final LifeCycleMethodsMap methodsMap;
    private final AtomicReference<Thread> shutdownHook = new AtomicReference();

    public LifeCycleManager(List<Object> managedInstances, LifeCycleMethodsMap methodsMap) throws LifeCycleStartException {
        this.methodsMap = methodsMap != null ? methodsMap : new LifeCycleMethodsMap();
        for (Object instance : managedInstances) {
            this.addInstance(instance);
        }
    }

    public int size() {
        return this.managedInstances.size();
    }

    public void start() throws LifeCycleStartException {
        if (!this.state.compareAndSet(State.LATENT, State.STARTING)) {
            throw new LifeCycleStartException("System already starting");
        }
        this.log.info("Life cycle starting...");
        for (Object e : this.managedInstances) {
            LifeCycleMethods methods = this.methodsMap.get(e.getClass());
            if (methods.hasFor(PreDestroy.class)) continue;
            this.managedInstances.remove(e);
        }
        Thread thread = new Thread(() -> {
            try {
                this.stop();
            }
            catch (Exception e) {
                this.log.error((Throwable)e, "Trying to shut down");
            }
        });
        this.shutdownHook.set(thread);
        Runtime.getRuntime().addShutdownHook(thread);
        this.state.set(State.STARTED);
        this.log.info("Life cycle startup complete. System ready.");
    }

    public void stopWithoutFailureLogging() throws LifeCycleStopException {
        ArrayList failures = new ArrayList();
        this.stop((klass, method, exception) -> failures.add(exception));
        if (!failures.isEmpty()) {
            LifeCycleStopException stopException = new LifeCycleStopException();
            for (Exception e : failures) {
                stopException.addSuppressed(e);
            }
            throw stopException;
        }
    }

    public void stop() throws LifeCycleStopException {
        AtomicBoolean failure = new AtomicBoolean(false);
        this.stop((klass, method, exception) -> {
            failure.set(true);
            this.log.error((Throwable)exception, "Exception in PreDestroy method %s::%s()", new Object[]{klass.getName(), method.getName()});
        });
        if (failure.get()) {
            throw new LifeCycleStopException();
        }
    }

    private void stop(LifeCycleStopFailureHandler handler) {
        if (!this.state.compareAndSet(State.STARTED, State.STOPPING)) {
            return;
        }
        Thread thread = this.shutdownHook.getAndSet(null);
        if (thread != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(thread);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this.log.info("Life cycle stopping...");
        ArrayList<Object> reversedInstances = new ArrayList<Object>(this.managedInstances);
        Collections.reverse(reversedInstances);
        for (Object e : reversedInstances) {
            this.stopInstance(e, handler);
        }
        this.state.set(State.STOPPED);
        this.log.info("Life cycle stopped.");
    }

    public void addInstance(Object instance) throws LifeCycleStartException {
        State currentState = this.state.get();
        Preconditions.checkState((currentState != State.STOPPING && currentState != State.STOPPED ? 1 : 0) != 0, (Object)"life cycle is stopped");
        this.startInstance(instance);
        if (this.methodsMap.get(instance.getClass()).hasFor(PreDestroy.class)) {
            this.managedInstances.add(instance);
        }
    }

    private void stopInstance(Object obj, LifeCycleStopFailureHandler handler) {
        this.log.debug("Stopping %s", new Object[]{obj.getClass().getName()});
        LifeCycleMethods methods = this.methodsMap.get(obj.getClass());
        for (Method preDestroy : methods.methodsFor(PreDestroy.class)) {
            this.log.debug("\t%s()", new Object[]{preDestroy.getName()});
            try {
                preDestroy.invoke(obj, new Object[0]);
            }
            catch (Exception e) {
                handler.handlePreDestroyException(obj.getClass(), preDestroy, LifeCycleManager.unwrapInvocationTargetException(e));
            }
        }
    }

    private void startInstance(Object obj) throws LifeCycleStartException {
        this.log.debug("Starting %s", new Object[]{obj.getClass().getName()});
        LifeCycleMethods methods = this.methodsMap.get(obj.getClass());
        for (Method postConstruct : methods.methodsFor(PostConstruct.class)) {
            this.log.debug("\t%s()", new Object[]{postConstruct.getName()});
            try {
                postConstruct.invoke(obj, new Object[0]);
            }
            catch (Exception e) {
                LifeCycleStartException failure = new LifeCycleStartException(String.format("Exception in PostConstruct method %s::%s()", obj.getClass().getName(), postConstruct.getName()), LifeCycleManager.unwrapInvocationTargetException(e));
                this.stopInstance(obj, (klass, method, exception) -> {
                    String message = String.format("Exception in PreDestroy method %1$s::%2$s() after PostConstruct failure in %1$s::%3$s()", klass.getName(), method.getName(), postConstruct.getName());
                    failure.addSuppressed(new RuntimeException(message, exception));
                });
                throw failure;
            }
        }
    }

    private static Exception unwrapInvocationTargetException(Exception e) {
        return e instanceof InvocationTargetException && e.getCause() instanceof Exception ? (Exception)e.getCause() : e;
    }

    private static enum State {
        LATENT,
        STARTING,
        STARTED,
        STOPPING,
        STOPPED;

    }

    private static interface LifeCycleStopFailureHandler {
        public void handlePreDestroyException(Class<?> var1, Method var2, Exception var3);
    }
}

