/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bootstrap;

import com.google.common.collect.ImmutableMap;
import com.google.inject.ConfigurationException;
import com.google.inject.Module;
import com.google.inject.ProvisionException;
import com.google.inject.spi.Message;
import io.airlift.bootstrap.Bootstrap;
import java.util.ArrayList;
import java.util.Map;
import javax.inject.Inject;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestBootstrap {
    @Test
    public void testRequiresExplicitBindings() throws Exception {
        Bootstrap bootstrap = new Bootstrap(new Module[0]);
        try {
            bootstrap.initialize().getInstance(Instance.class);
            Assert.fail((String)"should require explicit bindings");
        }
        catch (ConfigurationException e) {
            io.airlift.testing.Assertions.assertContains((String)((Message)e.getErrorMessages().iterator().next()).getMessage(), (String)"Explicit bindings are required");
        }
    }

    @Test
    public void testDoesNotAllowCircularDependencies() throws Exception {
        Bootstrap bootstrap = new Bootstrap(new Module[]{binder -> {
            binder.bind(InstanceA.class);
            binder.bind(InstanceB.class);
        }});
        try {
            bootstrap.initialize().getInstance(InstanceA.class);
            Assert.fail((String)"should not allow circular dependencies");
        }
        catch (ProvisionException e) {
            io.airlift.testing.Assertions.assertContains((String)((Message)e.getErrorMessages().iterator().next()).getMessage(), (String)"circular dependencies are disabled");
        }
    }

    @Test
    public void testEnvironmentVariableReplacement() {
        ImmutableMap original = ImmutableMap.builder().put((Object)"apple", (Object)"apple-value").put((Object)"grape", (Object)"${ENV:GRAPE}").put((Object)"peach", (Object)"${ENV:PEACH}").put((Object)"grass", (Object)"${ENV:!!!}").put((Object)"pear", (Object)"${ENV:X_PEAR}").put((Object)"cherry", (Object)"${ENV:X_CHERRY}").put((Object)"orange", (Object)"orange-value").build();
        ImmutableMap environment = ImmutableMap.builder().put((Object)"GRAPE", (Object)"env-grape").put((Object)"X_CHERRY", (Object)"env-cherry").build();
        ArrayList errors = new ArrayList();
        Map actual = Bootstrap.replaceEnvironmentVariables((Map)original, (Map)environment, (key, error) -> errors.add(error));
        ImmutableMap expected = ImmutableMap.builder().put((Object)"apple", (Object)"apple-value").put((Object)"grape", (Object)"env-grape").put((Object)"grass", (Object)"${ENV:!!!}").put((Object)"cherry", (Object)"env-cherry").put((Object)"orange", (Object)"orange-value").build();
        Assert.assertEquals((Map)actual, (Map)expected);
        Assertions.assertThat(errors).containsExactly((Object[])new String[]{"Configuration property 'peach' references unset environment variable 'PEACH'", "Configuration property 'pear' references unset environment variable 'X_PEAR'"});
    }

    public static class InstanceB {
        @Inject
        public InstanceB(InstanceA a) {
        }
    }

    public static class InstanceA {
        @Inject
        public InstanceA(InstanceB b) {
        }
    }

    public static class Instance {
    }
}

