/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bootstrap;

import com.google.inject.ConfigurationException;
import com.google.inject.Module;
import com.google.inject.ProvisionException;
import com.google.inject.spi.Message;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.testing.Assertions;
import javax.inject.Inject;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestBootstrap {
    @Test
    public void testRequiresExplicitBindings() throws Exception {
        Bootstrap bootstrap = new Bootstrap(new Module[0]);
        try {
            bootstrap.initialize().getInstance(Instance.class);
            Assert.fail((String)"should require explicit bindings");
        }
        catch (ConfigurationException e) {
            Assertions.assertContains((String)((Message)e.getErrorMessages().iterator().next()).getMessage(), (String)"Explicit bindings are required");
        }
    }

    @Test
    public void testDoesNotAllowCircularDependencies() throws Exception {
        Bootstrap bootstrap = new Bootstrap(new Module[]{binder -> {
            binder.bind(InstanceA.class);
            binder.bind(InstanceB.class);
        }});
        try {
            bootstrap.initialize().getInstance(InstanceA.class);
            Assert.fail((String)"should not allow circular dependencies");
        }
        catch (ProvisionException e) {
            Assertions.assertContains((String)((Message)e.getErrorMessages().iterator().next()).getMessage(), (String)"circular dependencies are disabled");
        }
    }

    public static class InstanceB {
        @Inject
        public InstanceB(InstanceA a) {
        }
    }

    public static class InstanceA {
        @Inject
        public InstanceA(InstanceB b) {
        }
    }

    public static class Instance {
    }
}

