/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bootstrap;

import io.airlift.bootstrap.LifeCycleMethods;
import io.airlift.bootstrap.LifeCycleMethodsMap;
import io.airlift.log.Logger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

public final class LifeCycleManager {
    private final Logger log = Logger.get(this.getClass());
    private final AtomicReference<State> state = new AtomicReference<State>(State.LATENT);
    private final Queue<Object> managedInstances = new ConcurrentLinkedQueue<Object>();
    private final LifeCycleMethodsMap methodsMap;
    private final AtomicReference<Thread> shutdownHook = new AtomicReference();

    public LifeCycleManager(List<Object> managedInstances, LifeCycleMethodsMap methodsMap) throws Exception {
        this.methodsMap = methodsMap != null ? methodsMap : new LifeCycleMethodsMap();
        for (Object instance : managedInstances) {
            this.addInstance(instance);
        }
    }

    public int size() {
        return this.managedInstances.size();
    }

    public void start() throws Exception {
        if (!this.state.compareAndSet(State.LATENT, State.STARTING)) {
            throw new Exception("System already starting");
        }
        this.log.info("Life cycle starting...");
        for (Object e : this.managedInstances) {
            LifeCycleMethods methods = this.methodsMap.get(e.getClass());
            if (methods.hasFor(PreDestroy.class)) continue;
            this.managedInstances.remove(e);
        }
        Thread thread = new Thread(() -> {
            try {
                this.stop();
            }
            catch (Exception e) {
                this.log.error((Throwable)e, "Trying to shut down");
            }
        });
        this.shutdownHook.set(thread);
        Runtime.getRuntime().addShutdownHook(thread);
        this.state.set(State.STARTED);
        this.log.info("Life cycle startup complete. System ready.");
    }

    public void stop() throws Exception {
        if (!this.state.compareAndSet(State.STARTED, State.STOPPING)) {
            return;
        }
        Thread thread = this.shutdownHook.getAndSet(null);
        if (thread != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(thread);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this.log.info("Life cycle stopping...");
        ArrayList<Object> reversedInstances = new ArrayList<Object>(this.managedInstances);
        Collections.reverse(reversedInstances);
        for (Object e : reversedInstances) {
            this.log.debug("Stopping %s", new Object[]{e.getClass().getName()});
            LifeCycleMethods methods = this.methodsMap.get(e.getClass());
            for (Method preDestroy : methods.methodsFor(PreDestroy.class)) {
                this.log.debug("\t%s()", new Object[]{preDestroy.getName()});
                preDestroy.invoke(e, new Object[0]);
            }
        }
        this.state.set(State.STOPPED);
        this.log.info("Life cycle stopped.");
    }

    public void addInstance(Object instance) throws Exception {
        State currentState = this.state.get();
        if (currentState == State.STOPPING || currentState == State.STOPPED) {
            throw new IllegalStateException();
        }
        this.startInstance(instance);
        if (this.methodsMap.get(instance.getClass()).hasFor(PreDestroy.class)) {
            this.managedInstances.add(instance);
        }
    }

    private void startInstance(Object obj) throws IllegalAccessException, InvocationTargetException {
        this.log.debug("Starting %s", new Object[]{obj.getClass().getName()});
        LifeCycleMethods methods = this.methodsMap.get(obj.getClass());
        for (Method postConstruct : methods.methodsFor(PostConstruct.class)) {
            this.log.debug("\t%s()", new Object[]{postConstruct.getName()});
            postConstruct.invoke(obj, new Object[0]);
        }
    }

    private static enum State {
        LATENT,
        STARTING,
        STARTED,
        STOPPING,
        STOPPED;

    }
}

