/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bootstrap;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.inject.Binder;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.PrivateModule;
import com.google.inject.Scopes;
import com.google.inject.Stage;
import io.airlift.bootstrap.AnInstance;
import io.airlift.bootstrap.AnotherInstance;
import io.airlift.bootstrap.DependentBoundInstance;
import io.airlift.bootstrap.DependentInstance;
import io.airlift.bootstrap.DependentInstanceImpl;
import io.airlift.bootstrap.ExecutedInstance;
import io.airlift.bootstrap.FooTestInstance;
import io.airlift.bootstrap.IllegalInstance;
import io.airlift.bootstrap.InstanceOne;
import io.airlift.bootstrap.InstanceThatRequiresStart;
import io.airlift.bootstrap.InstanceThatUsesInstanceThatRequiresStart;
import io.airlift.bootstrap.InstanceTwo;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.bootstrap.LifeCycleModule;
import io.airlift.bootstrap.PostConstructOnly;
import io.airlift.bootstrap.PreDestroyOnly;
import io.airlift.bootstrap.SimpleBase;
import io.airlift.bootstrap.SimpleBaseImpl;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestLifeCycleManager {
    private static final List<String> stateLog = new CopyOnWriteArrayList<String>();

    @BeforeMethod
    public void setup() {
        stateLog.clear();
    }

    static void note(String str) {
        stateLog.add(str);
    }

    @Test
    public void testImmediateStarts() throws Exception {
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new LifeCycleModule(), binder -> {
            binder.bind(InstanceThatRequiresStart.class).in(Scopes.SINGLETON);
            binder.bind(InstanceThatUsesInstanceThatRequiresStart.class).in(Scopes.SINGLETON);
        }});
        LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        lifeCycleManager.start();
        Assert.assertEquals(stateLog, (Collection)ImmutableList.of((Object)"InstanceThatUsesInstanceThatRequiresStart:OK"));
    }

    @Test
    public void testPrivateModule() throws Exception {
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new LifeCycleModule(), binder -> binder.install((Module)new PrivateModule(){

            protected void configure() {
                this.binder().bind(SimpleBase.class).to(SimpleBaseImpl.class).in(Scopes.SINGLETON);
                this.binder().expose(SimpleBase.class);
            }
        })});
        LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        lifeCycleManager.start();
        Assert.assertEquals(stateLog, (Collection)ImmutableList.of((Object)"postSimpleBaseImpl"));
        lifeCycleManager.stop();
        Assert.assertEquals(stateLog, (Collection)ImmutableList.of((Object)"postSimpleBaseImpl", (Object)"preSimpleBaseImpl"));
    }

    @Test
    public void testSubClassAnnotated() throws Exception {
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new LifeCycleModule(), binder -> binder.bind(SimpleBase.class).to(SimpleBaseImpl.class).in(Scopes.SINGLETON)});
        LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        lifeCycleManager.start();
        Assert.assertEquals(stateLog, (Collection)ImmutableList.of((Object)"postSimpleBaseImpl"));
        lifeCycleManager.stop();
        Assert.assertEquals(stateLog, (Collection)ImmutableList.of((Object)"postSimpleBaseImpl", (Object)"preSimpleBaseImpl"));
    }

    @Test
    public void testExecuted() throws Exception {
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new LifeCycleModule(), binder -> binder.bind(ExecutedInstance.class).in(Scopes.SINGLETON)});
        ExecutedInstance instance = (ExecutedInstance)((Object)injector.getInstance(ExecutedInstance.class));
        LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        lifeCycleManager.start();
        instance.waitForStart();
        Assert.assertEquals(stateLog, (Collection)ImmutableList.of((Object)"Starting"));
        lifeCycleManager.stop();
        instance.waitForEnd();
        Assert.assertEquals(stateLog, (Collection)ImmutableList.of((Object)"Starting", (Object)"Done"));
    }

    @Test
    public void testDeepDependency() throws Exception {
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new LifeCycleModule(), binder -> {
            binder.bind(AnInstance.class).in(Scopes.SINGLETON);
            binder.bind(AnotherInstance.class).in(Scopes.SINGLETON);
            binder.bind(DependentInstance.class).in(Scopes.SINGLETON);
        }});
        injector.getInstance(AnotherInstance.class);
        LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        lifeCycleManager.start();
        Assert.assertEquals(stateLog, (Collection)ImmutableList.of((Object)"postDependentInstance"));
        lifeCycleManager.stop();
        Assert.assertEquals(stateLog, (Collection)ImmutableList.of((Object)"postDependentInstance", (Object)"preDependentInstance"));
    }

    @Test
    public void testIllegalMethods() throws Exception {
        try {
            Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new Module(){

                public void configure(Binder binder) {
                    binder.bind(IllegalInstance.class).in(Scopes.SINGLETON);
                }
            }, new LifeCycleModule()});
            Assert.fail();
        }
        catch (CreationException creationException) {
            // empty catch block
        }
    }

    @Test
    public void testDuplicateMethodNames() throws Exception {
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new Module(){

            public void configure(Binder binder) {
                binder.bind(FooTestInstance.class).in(Scopes.SINGLETON);
            }
        }, new LifeCycleModule()});
        LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        lifeCycleManager.start();
        lifeCycleManager.stop();
        Assert.assertEquals(stateLog, (Collection)ImmutableList.of((Object)"foo"));
    }

    @Test
    public void testJITInjection() throws Exception {
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new LifeCycleModule(), binder -> {
            binder.bind(AnInstance.class).in(Scopes.SINGLETON);
            binder.bind(DependentInstance.class).in(Scopes.SINGLETON);
        }});
        injector.getInstance(AnInstance.class);
        LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        lifeCycleManager.start();
        lifeCycleManager.stop();
        Assert.assertEquals(stateLog, (Collection)ImmutableList.of((Object)"postDependentInstance", (Object)"preDependentInstance"));
    }

    @Test
    public void testNoPreDestroy() throws Exception {
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new LifeCycleModule(), binder -> {
            binder.bind(PostConstructOnly.class).in(Scopes.SINGLETON);
            binder.bind(PreDestroyOnly.class).in(Scopes.SINGLETON);
        }});
        injector.getInstance(PostConstructOnly.class);
        LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        lifeCycleManager.start();
        Assert.assertEquals(stateLog, (Collection)ImmutableList.of((Object)"makeMe"));
        lifeCycleManager.stop();
        Assert.assertEquals(stateLog, (Collection)ImmutableList.of((Object)"makeMe", (Object)"unmakeMe"));
    }

    @Test
    public void testModule() throws Exception {
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new LifeCycleModule(), binder -> {
            binder.bind(DependentBoundInstance.class).to(DependentInstanceImpl.class).in(Scopes.SINGLETON);
            binder.bind(DependentInstance.class).in(Scopes.SINGLETON);
            binder.bind(InstanceOne.class).in(Scopes.SINGLETON);
            binder.bind(InstanceTwo.class).in(Scopes.SINGLETON);
        }});
        LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        lifeCycleManager.start();
        lifeCycleManager.stop();
        HashSet stateLogSet = Sets.newHashSet(stateLog);
        Assert.assertEquals((Set)stateLogSet, (Set)Sets.newHashSet((Object[])new String[]{"postDependentBoundInstance", "postDependentInstance", "postMakeOne", "postMakeTwo", "preDestroyTwo", "preDestroyOne", "preDependentInstance", "preDependentBoundInstance"}));
    }
}

