package io.aiactiv.sdk.internal

import android.content.Context
import android.content.pm.PackageInfo
import android.content.pm.PackageManager
import android.os.Build
import java.lang.RuntimeException
import java.util.*

class UserAgentGenerator(private val context: Context) {
    private val packageInfo: PackageInfo?
        get() {
            try {
                return context.packageManager.getPackageInfo(context.packageName, PackageManager.GET_META_DATA)
            } catch (e: PackageManager.NameNotFoundException) {
                throw RuntimeException(e)
            }
        }

    val userAgent: String
        get() {
            val packageName = packageInfo?.packageName ?: DEFAULT_PACKAGE_NAME
            val versionName = packageInfo?.versionName ?: DEFAULT_VERSION_NAME
            val locale = Locale.getDefault()
            val sdkVersion = "1.0.0"
            return "$packageName/$versionName Aiactiv360SDK/${sdkVersion} " +
                    "(Linux; U; Android ${Build.VERSION.RELEASE}; " +
                    "${locale.language}-${locale.country}; " +
                    "${Build.MODEL} Build/${Build.ID})"
        }

    companion object {
        private const val DEFAULT_PACKAGE_NAME = "UNKNOWN"
        private const val DEFAULT_VERSION_NAME = "UNKNOWN"
    }
}