package io.aiactiv.sdk.internal

import android.net.Uri

open class UriUtils {
    companion object {
        private fun uriBuilder(baseUri: Uri, vararg newPathSegments: String): Uri.Builder {
            val builder = baseUri.buildUpon()
            for (path in newPathSegments) {
                builder.appendEncodedPath(path)
            }
            return builder
        }

        private fun uriBuilder(baseUri: String, vararg newPathSegments: String): Uri.Builder {
            return uriBuilder(Uri.parse(baseUri), *newPathSegments)
        }

        private fun appendQueryParams(uriBuilder: Uri.Builder,queryParams: Map<String, String>): Uri.Builder {
            for (param in queryParams) {
                uriBuilder.appendQueryParameter(param.key, param.value)
            }
            return uriBuilder
        }

        fun appendQueryParams(uri: Uri, queryParams: Map<String, String>): Uri {
            return appendQueryParams(uriBuilder(uri), queryParams).build()
        }

        fun appendQueryParams(baseUri: String, queryParams: Map<String, String>): Uri {
            return appendQueryParams(Uri.parse(baseUri), queryParams)
        }

        fun buildUri( baseUri: String, vararg newPathSegments: String): Uri {
            return uriBuilder(baseUri, *newPathSegments).build()
        }

        fun buildUri( baseUri: Uri, vararg newPathSegments: String): Uri {
            return uriBuilder(baseUri, *newPathSegments).build()
        }
    }
}