package io.aiactiv.sdk.internal

import android.content.Context
import android.net.*
import io.aiactiv.sdk.SingletonHolder

class NetworkService(private val context: Context) {

    private var network: Network?
    private var networkCapabilities: NetworkCapabilities?

    private val networkCallback = object : ConnectivityManager.NetworkCallback() {
        override fun onAvailable(network: Network) {
            super.onAvailable(network)
            this@NetworkService.network = network
            logger.debug("NetworkCallback onAvailable: $network")
        }

        override fun onUnavailable() {
            super.onUnavailable()
            network = null
        }

        override fun onLost(network: Network) {
            super.onLost(network)
            this@NetworkService.network = network
        }

        override fun onCapabilitiesChanged(
            network: Network,
            networkCapabilities: NetworkCapabilities
        ) {
            super.onCapabilitiesChanged(network, networkCapabilities)
            this@NetworkService.networkCapabilities = networkCapabilities
        }
    }

    private val connectivityManager: ConnectivityManager =
        context.getSystemService(Context.CONNECTIVITY_SERVICE) as ConnectivityManager

    fun isWifiConnected(): Boolean {
        return true
    }

    init {
        val networkRequest = NetworkRequest.Builder()
            .addCapability(NetworkCapabilities.NET_CAPABILITY_INTERNET)
            .addTransportType(NetworkCapabilities.TRANSPORT_WIFI)
            .addTransportType(NetworkCapabilities.TRANSPORT_CELLULAR)
            .addTransportType(NetworkCapabilities.TRANSPORT_BLUETOOTH)
            .build()
        connectivityManager.requestNetwork(networkRequest, networkCallback)

        network = connectivityManager.activeNetwork
        networkCapabilities = connectivityManager.getNetworkCapabilities(network)
    }

    companion object: SingletonHolder<NetworkService, Context>(::NetworkService) {
        private val logger = Logger.with(Logger.LogLevel.DEBUG)
    }
}