package io.aiactiv.sdk.internal

import android.content.Context
import kotlinx.coroutines.launch
import kotlinx.coroutines.runBlocking

class GetAdvertisingIdTask(
    private val context: Context,
    private val logger: Logger
) {

    fun getGooglePlayServicesAdvertisingID(context: Context): Pair<String?, Boolean> {
        val advertisingInfo = Class.forName("com.google.android.gms.ads.identifier.AdvertisingIdClient")
            .getMethod("getAdvertisingIdInfo", Context::class.java)
            .invoke(null, context)
        val isLimitAdTrackingEnabled = advertisingInfo.javaClass
            .getMethod("isLimitAdTrackingEnabled")
            .invoke(advertisingInfo) as Boolean

        if (isLimitAdTrackingEnabled) {
            logger.debug("Not collecting advertising ID because isLimitAdTrackingEnabled (Google Play Services) is true.")
            return  Pair(null, false)
        }

        val advertisingId = advertisingInfo.javaClass.getMethod("getId").invoke(advertisingInfo) as String?
        return Pair(advertisingId, true)
    }

    fun execute() {
        runBlocking {
            launch {
                getGooglePlayServicesAdvertisingID(context)
            }
        }
    }
}