package io.aiactiv.sdk.internal

import android.util.JsonWriter
import java.io.BufferedWriter
import java.io.Closeable
import java.io.IOException
import java.io.OutputStream
import java.io.OutputStreamWriter
import java.util.*

class BatchPayloadWriter(private val writeKey: String, stream: OutputStream, ): Closeable {

    private val bufferedWriter = BufferedWriter(OutputStreamWriter(stream))
    private val jsonWriter = JsonWriter(bufferedWriter)

    private var needsComma = false

    @Throws(IOException::class)
    fun beginObject(): BatchPayloadWriter {
        jsonWriter.beginObject()
        jsonWriter.name("writeKey").value("$writeKey@android")
        return this
    }

    @Throws(IOException::class)
    fun beginBatchArray(): BatchPayloadWriter {
        jsonWriter.name("batch").beginArray()
        needsComma = false
        return this
    }

    @Throws(IOException::class)
    fun emitPayloadObject(payload: String) {
        if (needsComma) {
            bufferedWriter.write(",")
        } else {
            needsComma = true
        }
        bufferedWriter.write(payload)
    }

    @Throws(IOException::class)
    fun endBatchArray(): BatchPayloadWriter {
        if (needsComma.not()) {
            throw IOException("At least one payload must be provided.")
        }
        jsonWriter.endArray()
        return this
    }

    @Throws(IOException::class)
    fun endObject(): BatchPayloadWriter {
        val end = Utils.toISO8601String(Date())
        jsonWriter.name("sentAt").value(end).endObject()
        return this
    }

    override fun close() {
        jsonWriter.close()
    }
}