package io.aiactiv.sdk.internal

class ApiResponse<T>(
    private val responseCode: ApiResponseCode,
    val responseData: T?,
    val errorData: ApiError,
) {

    val isSuccess: Boolean
        get() { return responseCode == ApiResponseCode.SUCCESS }

    val isNetworkError: Boolean
        get() { return responseCode == ApiResponseCode.NETWORK_ERROR }

    val isServerError: Boolean
        get() { return responseCode == ApiResponseCode.SERVER_ERROR }

    val isInternalError: Boolean
        get() { return responseCode == ApiResponseCode.INTERNAL_ERROR }

    companion object {

        private val EMPTY_RESULT_SUCCESS = ApiResponse(
            ApiResponseCode.SUCCESS,
            null,
            ApiError.DEFAULT,
        )

        fun <T> createAsError(responseCode: ApiResponseCode, errorData: ApiError): ApiResponse<T> {
            if (responseCode == ApiResponseCode.SUCCESS) {
                throw AssertionError()
            }
            return ApiResponse(responseCode, null, errorData)
        }

        @Suppress("UNCHECKED_CAST")
        fun <T> createAsSuccess(responseData: T?): ApiResponse<T> {
            if (responseData == null) {
                return EMPTY_RESULT_SUCCESS as ApiResponse<T>
            }
            return ApiResponse(
                ApiResponseCode.SUCCESS,
                responseData,
                ApiError.DEFAULT
            )
        }
    }
}