package io.aiactiv.sdk.analytics.integrations

import io.aiactiv.sdk.Properties
import java.util.*
import kotlin.collections.LinkedHashMap

class TrackPayload(
    messageId: String?,
    timestamp: Date?,
    context: Map<String, Any?>?,
    integrations: Map<String, Any?>?,
    userId: String?,
    anonymousId: String?,
    event: String?,
    properties: MutableMap<String, Any?>?,
    nanosecondTimestamps: Boolean
) : BasePayload(
    Type.track,
    messageId,
    timestamp,
    context,
    integrations,
    userId,
    anonymousId,
    nanosecondTimestamps
) {

    init {
        put(EVENT_KEY, event)
        put(PROPERTIES_KEY, properties)
    }

    fun event() = getString(EVENT_KEY)!!

    fun properties() = getValueMap(PROPERTIES_KEY, Properties::class.java)!!

    override fun toBuilder(): Builder {
        return Builder(this)
    }

    override fun toString(): String {
        return "TrackPayload{event = ${event()}}"
    }

    companion object {
        const val EVENT_KEY = "event"
        const val PROPERTIES_KEY = "properties"
    }

    open class Builder() : BasePayload.Builder<TrackPayload, Builder>() {

        private var event: String? = null
        private var properties: MutableMap<String, Any?>? = null

        constructor(payload: TrackPayload): this() {
            event = payload.event()
            properties = payload.properties()
        }

        open fun event(event: String): Builder {
            this.event = event
            return this
        }

        open fun properties(properties: MutableMap<String, Any?>): Builder {
            this.properties = Collections.unmodifiableMap(LinkedHashMap(properties))
            return this
        }

        override fun realBuild(
            messageId: String?,
            timestamp: Date?,
            context: Map<String, Any?>?,
            integrations: Map<String, Any?>?,
            userId: String?,
            anonymousId: String?,
            nanosecondTimestamps: Boolean
        ): TrackPayload {
            return TrackPayload(
                messageId,
                timestamp,
                context,
                integrations,
                userId,
                anonymousId,
                event,
                properties,
                nanosecondTimestamps
            )
        }

        override fun self(): Builder {
            return this
        }
    }
}