package io.aiactiv.sdk.analytics.integrations

import android.app.Activity
import android.os.Bundle
import io.aiactiv.sdk.Analytics
import io.aiactiv.sdk.internal.ValueMap

internal abstract class Integration<T> {

    interface Factory {
        fun create(settings: ValueMap?, analytics: Analytics): Integration<*>
        fun key(): String
    }

    /** @see android.app.Application.ActivityLifecycleCallbacks
     */
    open fun onActivityCreated(activity: Activity, savedInstanceState: Bundle?) {}

    /** @see android.app.Application.ActivityLifecycleCallbacks
     */
    open fun onActivityStarted(activity: Activity) {}

    /** @see android.app.Application.ActivityLifecycleCallbacks
     */
    open fun onActivityResumed(activity: Activity) {}

    /** @see android.app.Application.ActivityLifecycleCallbacks
     */
    open fun onActivityPaused(activity: Activity) {}

    /** @see android.app.Application.ActivityLifecycleCallbacks
     */
    open fun onActivityStopped(activity: Activity) {}

    /** @see android.app.Application.ActivityLifecycleCallbacks
     */
    open fun onActivitySaveInstanceState(activity: Activity, outState: Bundle?) {}

    /** @see android.app.Application.ActivityLifecycleCallbacks
     */
    open fun onActivityDestroyed(activity: Activity) {}

    /**
     * @see Analytics.identify
     */
    open fun identify(identify: IdentifyPayload) {}

//    /** @see Analytics.group
//     */
//    open fun group(group: GroupPayload?) {}

    /**
     * @see Analytics.track
     */
    open fun track(track: TrackPayload) {}

//    /** @see Analytics.alias
//     */
//    open fun alias(alias: AliasPayload?) {}

    /**
     * @see Analytics.screen
     */
    open fun screen(screen: ScreenPayload) {}

//    /** @see Analytics.flush
//     */
//    open fun flush() {}
//
//    /** @see Analytics.reset
//     */
//    open fun reset() {}

    /**
     * The underlying instance for this provider - used for integration specific actions. This will
     * return `null` for SDK's that only provide interactions with static methods (e.g.
     * Localytics).
     */
    open fun getUnderlyingInstance(): T? {
        return null
    }
}