package io.aiactiv.sdk.analytics.integrations

import io.aiactiv.sdk.analytics.Traits
import java.util.*
import kotlin.collections.LinkedHashMap

class IdentifyPayload(
    messageId: String?,
    timestamp: Date?,
    context: Map<String, Any?>?,
    integrations: Map<String, Any?>?,
    userId: String?,
    anonymousId: String?,
    traits: MutableMap<String, Any?>?,
    nanosecondTimestamps: Boolean
): BasePayload(
    Type.identity,
    messageId,
    timestamp,
    context,
    integrations,
    userId,
    anonymousId,
    nanosecondTimestamps,
) {

    init {
        put(TRAITS_KEY, traits)
    }

    fun traits() = getValueMap(TRAITS_KEY, Traits::class.java)

    override fun toString(): String {
        return "IdentifyPayload{\"userId=\"${userId()}}"
    }

    override fun toBuilder(): Builder {
        return Builder(this)
    }

    class Builder(): BasePayload.Builder<IdentifyPayload, Builder>() {

        private var traits: MutableMap<String, Any?>? = null

        constructor(payload: IdentifyPayload): this() {
            traits = payload.traits()
        }

        fun traits(traits: MutableMap<String, *>): Builder {
            this.traits = Collections.unmodifiableMap(LinkedHashMap(traits))
            return this
        }

        override fun realBuild(
            messageId: String?,
            timestamp: Date?,
            context: Map<String, Any?>?,
            integrations: Map<String, Any?>?,
            userId: String?,
            anonymousId: String?,
            nanosecondTimestamps: Boolean
        ): IdentifyPayload {
            if (userId.isNullOrEmpty() && traits.isNullOrEmpty()) {
                throw NullPointerException("either userId or traits are required")
            }

            return IdentifyPayload(
                messageId,
                timestamp,
                context,
                integrations,
                userId,
                anonymousId,
                traits,
                nanosecondTimestamps
            )
        }

        override fun self(): Builder {
            return this
        }
    }

    companion object {
        const val TRAITS_KEY = "traits"
    }
}