package io.aiactiv.sdk.adnetwork.models.container

import androidx.annotation.NonNull
import com.google.gson.annotations.SerializedName
import io.aiactiv.sdk.adnetwork.api.BidResponse

data class Inventory(@NonNull val id: Int, val metadata: Metadata) {

    @field:SerializedName("cpm")
    var cmp: Float? = 0.0F

    @field:SerializedName("ads_default")
    var defaultAds: BidResponse? = null

    @field:SerializedName("tracker_template")
    var trackerTemplate: TrackerTemplate? = null

    @field:SerializedName("dsps")
    var platforms: List<DemandSidePlatform>? = null

    @field:SerializedName("format")
    var format: String? = null

    @field:SerializedName("merge")
    var merge: String? = null

    @field:SerializedName("name")
    var name: String? = null

    @field:SerializedName("status")
    var status: String? = null

    @field:SerializedName("type")
    var type: String? = null

    @field:SerializedName("floor_price")
    var floorPrice: Float = 0.0F

    @field:SerializedName("position_id")
    var positionId: Int? = null

    @field:SerializedName("click_rate")
    var clickRate: Int? = null

    @field:SerializedName("fill_rate")
    var fillRate: Int? = null

    data class TrackerTemplate(val id: String) {

        @field:SerializedName("click_image")
        var clickImage: String? = null

        @field:SerializedName("click_url")
        var clickUrl: String? = null

        @field:SerializedName("code")
        var code: String? = null

        @field:SerializedName("name")
        var name: String? = null

        @field:SerializedName("price")
        var price: Int? = null

        @field:SerializedName("type")
        var type: String? = null
    }

    class Metadata {
        @field:SerializedName("background_color")
        var backgroundColor: String? = null

        @field:SerializedName("extension")
        var extension: String? = null

        @field:SerializedName("loop")
        var loop: Int? = 0

        @field:SerializedName("skip")
        var skip: Int? = 0

        @field:SerializedName("pass_back")
        var passBack: String? = null

        @field:SerializedName("width")
        var width: Int = 0

        @field:SerializedName("height")
        var height: Int = 0

        @field:SerializedName("mines")
        var mines: List<String>? = null

        @field:SerializedName("linearity")
        var linearity: Int? = null

        @field:SerializedName("skip_min")
        var skipMin: Int? = null

        @field:SerializedName("skip_after")
        var skipAfter: Int? = null

        @field:SerializedName("start_delay")
        var startDelay: Int? = null

        @field:SerializedName("min_bitrate")
        var minBitrate: Int? = null

        @field:SerializedName("max_bitrate")
        var maxBitrate: Int? = null

        @field:SerializedName("min_duration")
        var minDuration: Int? = null

        @field:SerializedName("max_duration")
        var maxDuration: Int? = null

        @field:SerializedName("protocols")
        var protocols: List<Int>? = null
    }
}