package io.aiactiv.sdk.adnetwork.models.bid

import com.google.gson.annotations.SerializedName
import java.util.*

/**
 * This object describes the nature and behavior of the entity that is
 * the source of the bid request upstream from the exchange.
 * The primary purpose of this object is to define post-auction or upstream decisioning
 * when the exchange itself does not control the final decision.
 * A common example of this is header bidding,
 * but it can also apply to upstream server entities such as another RTB exchange,
 * a mediation platform, or an ad server combines direct campaigns with 3rd party demand in decisioning.
 */
class Source {
    /**
     * Entity responsible for the final impression sale decision,
     * where 0 = exchange, 1 = upstream source.
     */
    @field:SerializedName("fd")
    var finalDecision: Int? = null

    /**
     * Transaction ID that must be common across all participants in this bid request
     * (e.g., potentially multiple exchanges).
     */
    @field:SerializedName("tid")
    val transactionId: String = UUID.randomUUID().toString()

    /**
     * Payment ID chain string containing embedded syntax described in the TAG Payment ID Protocol v1.0.
     */
    @field:SerializedName("pchain")
    var paymentChainId: String? = null

}