package io.aiactiv.sdk.adnetwork.models.bid

import com.google.gson.annotations.SerializedName

/**
 * This object contains any legal, governmental, or industry regulations that apply to the request.
 * The coppa flag signals whether or not the request falls under the
 * United States Federal Trade Commission’s regulations for the
 * United States Children’s Online Privacy Protection Act (“COPPA”).
 */
class Regs {
    /**
     * Flag indicating if this request is subject to the COPPA regulations established by the USA FTC,
     * where 0 = no, 1 = yes.
     */
    @field:SerializedName("coppa")
    var coppa: Int? = null

    /**
     * Placeholder for bidder-specific extensions to OpenRTB.
     */
    @field:SerializedName("ext")
    var extension: Any? = null
}