package io.aiactiv.sdk.adnetwork.models.bid

import com.google.gson.annotations.SerializedName

/**
 * The private marketplace container for direct deals between buyers and sellers
 * that may pertain to this impression.
 * The actual deals are represented as a collection of [Deal] objects
 */
class Pmp {
    /**
     * Indicator of auction eligibility to seats named in the Direct Deals object,
     * where 0 = all bids are accepted,
     * 1 = bids are restricted to the deals specified and the terms thereof.
     */
    @field:SerializedName("private_auction")
    var privateAuction: Int = 0

    /**
     * Array of [Deal] objects that convey the specific deals applicable to this impression.
     */
    @field:SerializedName("deals")
    var deals: Array<Deal>? = null

    /**
     * Placeholder for exchange-specific extensions to OpenRTB.
     */
    @field:SerializedName("ext")
    var extension: Any? = null
}