package io.aiactiv.sdk.adnetwork.models.bid

/**
 * The context in which the ad appears - what type of content is surrounding the ad on the page at a high level.
 */
class NativeContextType {
    companion object {
        /**
         * Content-centric context such as newsfeed, article, image gallery, video gallery, or similar.
         */
        const val CONTENT_CENTRIC = 1

        /**
         * Social-centric context such as social network feed, email, chat, or similar.
         */
        const val SOCIAL_CENTRIC = 2

        /**
         * Product context such as product listings, details, recommendations, reviews, or similar.
         */
        const val PRODUCT = 3
    }
}