package io.aiactiv.sdk.adnetwork.models.bid

class NativeContextSubType {
    companion object {
        /**
         * General or mixed content.
         */
        const val GENERAL = 10

        /**
         * Primarily article content (which of course could include images, etc as part of the article)
         */
        const val PRIMARILY_ARTICLE = 11

        /**
         * Primarily video content
         */
        const val PRIMARILY_VIDEO = 12

        /**
         * Primarily audio content
         */
        const val PRIMARILY_AUDIO = 13

        /**
         * Primarily image content
         */
        const val PRIMARILY_IMAGE = 14

        /**
         * User-generated content - forums, comments, etc
         */
        const val USER_GENERATED = 15

        /**
         * General social content such as a general social network
         */
        const val SOCIAL_CONTENT = 20

        /**
         * Primarily email content
         */
        const val PRIMARILY_EMAIL = 21

        /**
         * Primarily chat/IM content
         */
        const val PRIMARILY_CHAT = 22

        /**
         * Content focused on selling products, whether digital or physical
         */
        const val SELLING_PRODUCTS = 30

        /**
         * Application store/marketplace
         */
        const val APPLICATION_STORE = 31

        /**
         * Product reviews site primarily (which may sell product secondarily)
         */
        const val PRODUCT_REVIEW_SITE = 32
    }
}