package io.aiactiv.sdk.adnetwork.models.bid

import com.google.gson.annotations.SerializedName

/**
 * The native object is the top level JSON object which identifies a native response.
 */
class NativeAdResponse(
    /**
     * Destination Link. This is default link object for the ad.
     * Individual assets can also have a link object which applies if the asset is activated(clicked).
     * If the asset doesn't have a link object, the parent link object applies
     */
    @SerializedName("link")
    val link: Link? = null
) {
    /**
     * Version of the Native Markup version in use.
     */
    @SerializedName("ver")
    var version: String = "1.2"

    /**
     * List of native ad’s assets. Required if no [assetsUrl].
     * Recommended as fallback even if [assetsUrl] is provided.
     */
    @SerializedName("assets")
    val assets: Array<Asset.Response>? = null

    /**
     * URL of an alternate source for the assets object.
     * The expected response is a JSON object mirroring the assets object in the bid response,
     * subject to certain requirements as specified in the individual objects.
     * Where present, overrides the asset object in the response.
     */
    @SerializedName("assetsurl")
    var assetsUrl: String? = null

    /**
     * URL where a dynamic creative specification may be found for populating this ad,
     * per the Dynamic Content Ads Specification.
     */
    @SerializedName("dcourl")
    var dcoUrl: String? = null

    /**
     * Array of tracking objects to run with the ad,
     * in response to the declared supported methods in the request.
     */
    @SerializedName("eventtrackers")
    var eventTrackers: Array<EventTracker>? = null

    /**
     * Set to 1 when the native ad supports buyer-specific privacy notice.
     * Set to 0 (or field absent) when the native ad doesn't support custom privacy links or if support is unknown.
     */
    @SerializedName("privacy")
    var privacy: Int = 0

    /**
     * Placeholder for exchange-specific extensions to OpenRTB.
     */
    @field:SerializedName("ext")
    var extension: Any? = null
}