package io.aiactiv.sdk.adnetwork.models.bid

import com.google.gson.annotations.SerializedName

/**
 * The Native Object defines the native advertising opportunity available for bid via this bid request.
 * It will be included as a JSON-encoded string in the bid request’s imp.native field or as a direct JSON object,
 * depending on the choice of the exchange.
 */
class NativeAdRequest(
    /**
     * An array of Asset Objects. Any bid response must comply with the array of elements
     * expressed in the bid request.
     */
    @SerializedName("assets")
    private val assets: Array<Asset.Request>
) {
    /**
     * Version of the Native Markup version in use.
     */
    @SerializedName("ver")
    var version: String = "1.2"

    /**
     * The context in which the ad appears.
     */
    @SerializedName("context")
    var contextTypeID: Int? = null

    /**
     * A more detailed context in which the ad appears.
     */
    @SerializedName("contextsubtype")
    var contextSubTypeID: Int = 1

    /**
     * The design/format/layout of the ad unit being offered.
     */
    @SerializedName("plcmttype")
    var placementTypeID: Int = 1

    /**
     * The number of identical placements in this Layout.
     */
    @SerializedName("plcmtcnt")
    var numOfPlacementID: Int = 1

    /**
     * 0 for the first ad, 1 for the second ad, and so on.
     * Note this would generally NOT be used in combination with [numOfPlacementID] -
     * either you are auctioning multiple identical placements
     * (in which case [numOfPlacementID]>1, [sequence]=0)
     * or you are holding separate auctions for distinct items in the feed
     * (in which case [numOfPlacementID]=1, [sequence]=>=1)
     */
    @SerializedName("seq")
    var sequence: Int = 0

    /**
     * Whether the supply source / impression supports returning an assets url instead of an asset object.
     * 0 or the absence of the field indicates no such support.
     */
    @SerializedName("aurlsupport")
    var assetUrlSupport: Int = 0

    /**
     * Whether the supply source / impression supports returning a dco url instead of an asset object.
     * 0 or the absence of the field indicates no such support. Beta feature.
     */
    @SerializedName("durlsupport")
    var dcoUrlSupport: Int = 0

    /**
     * Specifies what type of event tracking is supported
     */
    @SerializedName("eventtrackers")
    var eventTrackers: Array<EventTracker>? = null

    /**
     * Set to 1 when the native ad supports buyer-specific privacy notice.
     * Set to 0 (or field absent) when the native ad doesn't support custom privacy links or if support is unknown.
     */
    @SerializedName("privacy")
    var privacy: Int = 0

    /**
     * Placeholder for exchange-specific extensions to OpenRTB.
     */
    @field:SerializedName("ext")
    var extension: Any? = null
}