package io.aiactiv.sdk.adnetwork.models.bid

import androidx.annotation.FloatRange
import com.google.gson.annotations.SerializedName

/**
 * This object is associated with an [Impression] as an array of metrics.
 * These metrics can offer insight into the impression to assist with
 * decisioning such as average recent viability, click-through rate, etc.
 * Each metric is identified by its type, reports the value of the metric,
 * and optionally identifies the source or vendor measuring the value.
 */
class Metric(
    /**
     * Type of metric being presented using exchange curated string names
     * which should be published to bidders a priori.
     */
    @field:SerializedName("id")
    private val id: String,

    /**
     * Number representing the value of the metric.
     * Probabilities must be in the range 0.0 – 1.0.
     */
    @field:SerializedName("value")
    @FloatRange(from = 0.0, to = 1.0) private val value: Float,
) {
    /**
     * Source of the value using exchange curated string names
     * which should be published to bidders a priori.
     * If the exchange itself is the source versus a third party, “EXCHANGE” is recommended.
     */
    @field:SerializedName("vendor")
    var vendor: String? = null

    /**
     * Placeholder for exchange-specific extensions to OpenRTB.
     */
    @field:SerializedName("ext")
    var extension: Any? = null
}