package io.aiactiv.sdk.adnetwork.models.bid

import com.google.gson.annotations.SerializedName

/**
 * Used for ‘call to action’ assets, or other links from the Native ad.
 * This Object should be associated to its peer object in the parent Asset Object
 * or as the master link in the top level Native Ad response object.
 * When that peer object is activated (clicked) the action
 * should take the user to the location of the link.
 */
class Link(
    /**
     * Landing URL of the clickable link.
     */
    @SerializedName("url")
    val url: String
) {
    /**
     * List of third-party tracker URLs to strings be fired on click of the URL.
     */
    @SerializedName("clicktrackers")
    val clickTrackers: Array<String>? = null

    /**
     * Fallback URL for deeplink. To be used if the URL given in url is not supported by the device.
     */
    @SerializedName("fallback")
    val fallbackURL: String? = null

    /**
     * Placeholder for exchange-specific extensions to OpenRTB.
     */
    @field:SerializedName("ext")
    var extension: Any? = null
}