package io.aiactiv.sdk.adnetwork.models.bid

import com.google.gson.annotations.SerializedName

/**
 * This object represents an allowed size (i.e., height and width combination)
 * or Flex Ad parameters for a banner impression.
 * These are typically used in an array where multiple sizes are permitted.
 * It is recommended that either the w/h pair or the wratio/hratio/wmin set
 * (i.e., for Flex Ads) be specified.
 */
class Format {

    /**
     * Width in device independent pixels (DIPS).
     */
    @field:SerializedName("w")
    var width: Int? = null

    /**
     * Height in device independent pixels (DIPS).
     */
    @field:SerializedName("h")
    var height: Int? = null

    /**
     * Relative width when expressing size as a ratio.
     */
    @field:SerializedName("wratio")
    var widthRatio: Int? = null

    /**
     * Relative height when expressing size as a ratio.
     */
    @field:SerializedName("hratio")
    var heightRatio: Int? = null

    /**
     * The minimum width in device independent pixels (DIPS)
     * at which the ad will be displayed the size is expressed as a ratio.
     */
    @field:SerializedName("wmin")
    var widthMin: Int? = null

    /**
     * Placeholder for exchange-specific extensions to OpenRTB.
     */
    @field:SerializedName("ext")
    var extension: Any? = null
}