package io.aiactiv.sdk.adnetwork.models.bid

import com.google.gson.annotations.SerializedName

/**
 * The event trackers object specifies the types of events the bidder can request to be tracked in the bid response,
 * and which types of tracking are available for each event type, and is included as an array in the request.
 */
class EventTracker(
    /**
     * Type of event available for tracking. [EventTracker.EventType]
     */
    @SerializedName("event")
    private val eventType: Int,

    /**
     * Array of the types of tracking available for the given event. [EventTracker.EventMethod]
     */
    @SerializedName("methods")
    private val methods: Array<Int>,
) {
    /**
     * Placeholder for exchange-specific extensions to OpenRTB.
     */
    @field:SerializedName("ext")
    var extension: Any? = null

    class EventType {
        companion object {
            /**
             * Impression
             */
            const val IMPRESSION = 1

            /**
             * Visible impression using MRC definition at 50% in view for 1 second
             */
            const val VIEWABLE_MRC_50 = 2

            /**
             * 100% in view for 1 second (ie GroupM standard)
             */
            const val VIEWABLE_MRC_100 = 3

            /**
             * Visible impression for video using MRC definition at 50% in view for 2 seconds
             */
            const val VIEWABLE_VIDEO_50 = 4
        }
    }

    class EventMethod {
        companion object {
            /**
             * Image-pixel tracking - URL provided will be inserted as a 1x1 pixel at the time of the event.
             */
            const val IMAGE = 1

            /**
             * Javascript-based tracking - URL provided will be inserted as a js tag at the time of the event.
             */
            const val JAVASCRIPT = 2
        }
    }
}