package io.aiactiv.sdk.adnetwork.models.bid

import androidx.annotation.NonNull
import com.google.gson.annotations.SerializedName

/**
 * This object constitutes a specific deal that was struck a priori between a buyer and a seller.
 * Its presence with the Pmp collection indicates that
 * this impression is available under the terms of that deal.
 */
class Deal(
    /**
     * A unique identifier for the direct deal.
     */
    @field:SerializedName("id")
    @NonNull val id: String,
) {

    /**
     * Minimum bid for this impression expressed in CPM.
     */
    @field:SerializedName("bidfloor")
    var bidFloor: Int = 0

    /**
     * Currency specified using ISO-4217 alpha codes.
     * This may be different from bid currency returned by bidder if this is allowed by the exchange.
     */
    @field:SerializedName("bidfloorcur")
    var bidFloorCurrency: String = "USD"

    /**
     * Optional override of the overall auction type of the bid request, where
     * 1 = First Price,
     * 2 = Second Price Plus,
     * 3 = the value passed in bidfloor is the agreed upon deal price.
     * Additional auction types can be defined by the exchange.
     */
    @field:SerializedName("at")
    var at: Int? = null

    /**
     * Whitelist of buyer seats (e.g., advertisers, agencies) allowed to bid on this deal.
     * IDs of seats and the buyer’s customers to which they refer must be coordinated between
     * bidders and the exchange a priori. Omission implies no seat restrictions.
     */
    @field:SerializedName("wseat")
    var whiteListSeatIDs: Array<String>? = null

    /**
     * Array of advertiser domains (e.g., advertiser.com) allowed to bid on this deal.
     * Omission implies no advertiser restrictions.
     */
    @field:SerializedName("wadomain")
    var advertiserDomains: Array<String>? = null

    /**
     * Placeholder for exchange-specific extensions to OpenRTB.
     */
    @field:SerializedName("ext")
    var extension: Any? = null
}