package io.aiactiv.sdk.adnetwork.models.bid

import androidx.annotation.NonNull
import com.google.gson.annotations.SerializedName

/**
 * A SeatBid object contains one or more Bid objects,
 * each of which relates to a specific impression in the bid request
 * via the impid attribute and constitutes an offer to buy that impression for a given price.
 */
class Bid(
    /**
     * Bidder generated bid ID to assist with logging/tracking.
     */
    @field:SerializedName("id")
    @NonNull val id: String,

    /**
     * ID of the [Impression] object in the related bid request.
     */
    @field:SerializedName("impid")
    @NonNull val impressionId: String,

    /**
     * Bid price expressed as CPM although the actual transaction is for a unit impression only.
     */
    @field:SerializedName("price")
    @NonNull val price: Float,
) {

    /**
     * Win notice URL called by the exchange if the bid wins
     * (not necessarily indicative of a delivered, viewed, or billable ad);
     * optional means of serving ad markup.
     */
    @field:SerializedName("nurl")
    var winUrl: String? = null

    /**
     * Billing notice URL called by the exchange when a winning bid becomes billable
     * based on exchange-specific business policy (e.g., typically delivered, viewed, etc.)
     */
    @field:SerializedName("burl")
    var billUrl: String? = null

    /**
     * Loss notice URL called by the exchange when a bid is known to have been lost.
     */
    @field:SerializedName("lurl")
    var lossUrl: String? = null

    /**
     * Optional means of conveying ad markup in case the bid wins;
     * supersedes the win notice if markup is included in both.
     */
    @field:SerializedName("adm")
    var adMarkup: String? = null

    /**
     * ID of a preloaded ad to be served if the bid wins.
     */
    @field:SerializedName("adid")
    var preloadedAdId: String? = null

    /**
     * Advertiser domain for block list checking (e.g., “ford.com”).
     * This can be an array of for the case of rotating creatives.
     * Exchanges can mandate that only one domain is allowed.
     */
    @field:SerializedName("adomain")
    var advertiserDomains: Array<String>? = null

    /**
     * A platform-specific application identifier intended to be unique to the app and independent of the exchange.
     * On Android, this should be a bundle or package name (e.g., com.foo.game). On iOS, it is a numeric ID.
     */
    @field:SerializedName("bundle")
    var bundle: String? = null

    /**
     * URL without cache-busting to an image that is representative of the content of the campaign
     * for ad quality/safety checking.
     */
    @field:SerializedName("iurl")
    var imageUrl: String? = null

    /**
     * Campaign ID to assist with ad quality checking;
     * the collection of creatives for which imageUrl should be representative.
     */
    @field:SerializedName("cid")
    var campaignId: String? = null

    /**
     * Creative ID to assist with ad quality checking.
     */
    @field:SerializedName("crid")
    var creativeId: String? = null

    /**
     * Tactic ID to enable buyers to label bids for reporting to the
     * exchange the tactic through which their bid was submitted.
     * The specific usage and meaning of the tactic ID should be communicated between buyer and exchanges a priori.
     */
    @field:SerializedName("tactic")
    var tacticId: String? = null

    /**
     * IAB content categories of the creative.
     */
    @field:SerializedName("cat")
    var categories: Array<String>? = null

    /**
     * Set of attributes describing the creative.
     */
    @field:SerializedName("attr")
    var attributes: Array<CreativeAttribute>? = null

    /**
     * API required by the markup if applicable.
     */
    @field:SerializedName("api")
    var api: ApiFramework? = null

    /**
     * Video response protocol of the markup if applicable.
     */
    @field:SerializedName("protocol")
    var protocol: Int? = null

    /**
     * Creative media rating per IQG guidelines.
     */
    @field:SerializedName("qagmediarating")
    var mediaRating: MediaRating? = null

    /**
     * Language of the creative using ISO-639-1-alpha-2.
     * The non- standard code “xx” may also be used if the creative has no linguistic content
     * (e.g., a banner with just a company logo).
     */
    @field:SerializedName("language")
    var language: String? = null

    /**
     * Reference to the deal.id from the bid request if this bid pertains to a private marketplace direct deal.
     */
    @field:SerializedName("dealid")
    var dealId: String? = null

    /**
     * Width of the creative in device independent pixels (DIPS).
     */
    @field:SerializedName("w")
    var width: Int? = null

    /**
     * Height of the creative in device independent pixels (DIPS).
     */
    @field:SerializedName("h")
    var height: Int? = null

    /**
     * Relative width of the creative when expressing size as a ratio. Required for Flex Ads.
     */
    @field:SerializedName("wratio")
    var widthRatio: Int? = null

    /**
     * Relative height of the creative when expressing size as a ratio. Required for Flex Ads.
     */
    @field:SerializedName("hratio")
    var heightRatio: Int? = null

    /**
     * Advisory as to the number of seconds the bidder is willing to wait between the auction and the actual impression.
     */
    @field:SerializedName("epx")
    var expired: Int? = null

    /**
     * Placeholder for bidder-specific extensions to OpenRTB.
     */
    @field:SerializedName("ext")
    var extension: Extension? = null

    class Extension {
        @field:SerializedName("prebid")
        var preBid: PreBid? = null
    }
}