package io.aiactiv.sdk.adnetwork.models.bid

import com.google.gson.annotations.SerializedName

/**
 * This object represents the most general type of impression.
 * Although the term “banner” may have very specific meaning in other contexts,
 * here it can be many things including a simple static image,
 * an expandable ad unit, or even in-banner video
 */
class Banner {

    @field:SerializedName("id")
    var id: String? = null

    /**
     * Array of format objects representing the banner sizes permitted.
     * If none are specified, then use of the h and w attributes is highly recommended.
     */
    @field:SerializedName("format")
    var formats: Array<Format>? = null

    /**
     * Exact width in device independent pixels (DIPS);
     * recommended if no format objects are specified.
     */
    @field:SerializedName("w")
    var width: Int? = null

    /**
     * Exact height in device independent pixels (DIPS);
     * recommended if no format objects are specified.
     */
    @field:SerializedName("h")
    var height: Int? = null

    /**
     * Blocked banner ad types.
     */
    @field:SerializedName("btype")
    var blocked: BannerAdType? = null

    /**
     * Blocked creative attributes
     */
    @field:SerializedName("battr")
    var attributes: Array<CreativeAttribute>? = null

    /**
     * Ad position on screen.
     */
    @field:SerializedName("pos")
    var position: AdPosition? = null

    /**
     * Content MIME types supported.
     * Popular MIME types may include “application/x-shockwave-flash”, “image/jpg”, and “image/gif”.
     */
    @field:SerializedName("mines")
    var mines: Array<String>? = null

    /**
     * Indicates if the banner is in the top frame as opposed to an iframe,
     * where 0 = no, 1 = yes.
     */
    @field:SerializedName("topframe")
    var topFrame: Int? = null

    /**
     * Directions in which the banner may expand.
     */
    @field:SerializedName("expdir")
    var expandableDirection: Array<ExpandableDirection>? = null

    /**
     * List of supported [ApiFramework] for this impression.
     * If an API is not explicitly listed, it is assumed not to be supported.
     */
    @field:SerializedName("api")
    var apis: Array<ApiFramework>? = null

    /**
     * Relevant only for Banner objects used with a Video object
     */
    @field:SerializedName("vcm")
    var videoCompanion: VideoCompanion? = null

    /**
     * Placeholder for exchange-specific extensions to OpenRTB.
     */
    @field:SerializedName("ext")
    var extension: Any? = null
}