package io.aiactiv.sdk.adnetwork.models.bid

import com.google.gson.annotations.SerializedName

/**
 * The Image object to be used for all image elements of the Native ad such as Icons, Main Image, etc.
 */
class AssetImage {

    class Request {
        /**
         * Type ID of the image [AssetImage.Type] element supported by the publisher.
         * The publisher can display this information in an appropriate format.
         */
        @SerializedName("type")
        var type: Int? = null

        /**
         * Width of the image in pixels.
         */
        @SerializedName("w")
        var width: Int? = null

        /**
         * The minimum requested width of the image in pixels.
         * This option should be used for any rescaling of images by the client.
         * Either [width] or [minWidth] should be transmitted.
         * If only [width] is included, it should be considered an exact requirement.
         */
        @SerializedName("wmin")
        var minWidth: Int? = null

        /**
         * Height of the image in pixels.
         */
        @SerializedName("h")
        var height: Int? = null

        /**
         * The minimum requested height of the image in pixels.
         * This option should be used for any rescaling of images by the client.
         * Either [height] or [minHeight] should be transmitted.
         * If only [height] is included, it should be considered an exact requirement.
         */
        @SerializedName("hmin")
        var minHeight: Int? = null

        /**
         * Whitelist of content MIME types supported. Popular MIME types include,
         * but are not limited to “image/jpg” “image/gif”.
         * If blank, assume all types are allowed
         */
        @SerializedName("mimes")
        var mimes: Array<String>? = null

        /**
         * Placeholder for exchange-specific extensions to OpenRTB.
         */
        @field:SerializedName("ext")
        var extension: Any? = null
    }

    class Response(
        /**
         * URL of the image asset.
         */
        @SerializedName("url")
        val url: String,
    ) {
        /**
         * Type ID of the image [AssetImage.Type] element supported by the publisher.
         * The publisher can display this information in an appropriate format.
         */
        @SerializedName("type")
        var type: Int? = null

        /**
         * Width of the image in pixels.
         */
        @SerializedName("w")
        var width: Int? = null

        /**
         * Height of the image in pixels.
         */
        @SerializedName("h")
        var height: Int? = null

        /**
         * Placeholder for exchange-specific extensions to OpenRTB.
         */
        @field:SerializedName("ext")
        var extension: Any? = null
    }

    class Type {
        companion object {
            /**
             * Icon image
             * Optional. max height: at least 50, aspect ratio: 1:1
             */
            const val ICON = 1

            /**
             * Large image preview for the ad
             * At least one of 2 size variants required:
             * Small Variant:
             * - max height: at least 200
             * - max width: at least 200, 267, or 382
             * - aspect ratio: 1:1, 4:3, or 1.91:1
             * Large Variant:
             * - max height: at least 627
             * - max width: at least 627, 836, or 1198
             * - aspect ratio: 1:1, 4:3, or 1.91:1
             */
            const val MAIN = 3
        }
    }
}