package io.aiactiv.sdk.adnetwork.models.bid

import com.google.gson.annotations.SerializedName

/**
 * The Data Object is to be used for all non-core elements of the native unit such as
 * Brand Name, Ratings, Review Count, Stars, Download count, descriptions etc.
 * It is also generic for future native elements not contemplated at the time of the writing of this document.
 */
class AssetData {

    class Request {
        /**
         * Type ID of the element supported by the publisher. [AssetData.Type]
         * The publisher can display this information in an appropriate format.
         * See Data Asset Types table for commonly used examples.
         */
        @SerializedName("type")
        var type: Int? = 0

        /**
         * Maximum length of the text in the element’s response.
         */
        @SerializedName("len")
        var length: Int? = 0

        /**
         * Placeholder for exchange-specific extensions to OpenRTB.
         */
        @field:SerializedName("ext")
        var extension: Any? = null
    }

    class Response(
        /**
         * The formatted string of data to be displayed.
         * Can contain a formatted value such as “5 stars” or “$10” or “3.4 stars out of 5”.
         */
        @SerializedName("value")
        val value: String,
    ) {
        /**
         * Required for assetsurl/dcourl responses, not required for embedded asset responses.
         */
        @SerializedName("type")
        var type: Int? = 0

        /**
         * Required for assetsurl/dcourl responses, not required for embedded asset responses.
         * The length of the data element being submitted.
         */
        @SerializedName("len")
        var length: Int? = 0

        /**
         * Placeholder for exchange-specific extensions to OpenRTB.
         */
        @field:SerializedName("ext")
        var extension: Any? = null
    }

    class Type {
        companion object {
            /**
             * Sponsored By message where response should contain the brand name of the sponsor.
             */
            const val SPONSORED = 1

            /**
             * Descriptive text associated with the product or service being advertised.
             * Longer length of text in response may be truncated or ellipse by the exchange.
             */
            const val DESCRIPTION = 2

            /**
             * Rating of the product being offered to the user.
             * For example an app's rating in an app store from 0-5.
             */
            const val RATING = 3

            /**
             * Number of social ratings or “likes” of the product being offered to the user.
             */
            const val SOCIAL_LIKES = 4

            /**
             * Number downloads/installs of this product
             */
            const val DOWNLOADS = 5

            /**
             * Price for product / app / in-app purchase. Value should include currency symbol in localised format.
             */
            const val PRICE = 6

            /**
             * Sale price that can be used together with price to indicate a discounted price
             * compared to a regular price. Value should include currency symbol in localised format.
             */
            const val SEAL_PRICE = 7

            /**
             * Phone number
             */
            const val PHONE_NUMBER = 8

            /**
             * Address
             */
            const val ADDRESS = 9

            /**
             * Additional descriptive text associated text with the product or service being advertised
             */
            const val ADDITIONAL_DESCRIPTIVE = 10

            /**
             * Display URL for the ad. To be text used when sponsoring entity doesn't own the content.
             * IE sponsored by BRAND on SITE (where SITE is transmitted in this field).
             */
            const val DISPLAY_URL = 11

            /**
             * CTA description - descriptive text describing a ‘call to action’ button for the destination URL.
             */
            const val CTA_DESCRIPTION = 12
        }
    }
}