package io.aiactiv.sdk.adnetwork.models.bid

import com.google.gson.annotations.SerializedName

/**
 * The main container object for each asset requested or supported by Exchange on behalf of the rendering client.
 * Any object that is required is to be flagged as such.
 * Only one of the {title,img,video,data} objects should be present in each object. All others should be null/absent.
 * The id is to be unique within the AssetObject array so that the response can be aligned.
 */
class Asset {
    class Request {
        /**
         * Unique asset ID, assigned by exchange. Typically a counter for the array
         */
        @SerializedName("id")
        var id: Int? = null

        /**
         * Set to 1 if asset is required (exchange will not accept a bid without it)
         */
        @SerializedName("required")
        var required: Int = 0

        /**
         * Title object for title assets.
         */
        @SerializedName("title")
        var title: AssetTitle.Request? = null

        /**
         * Image object for image assets.
         */
        @SerializedName("img")
        var image: AssetImage.Request? = null

        /**
         * Video object for video assets. Note that in-stream (ie pre-roll, etc) video ads are not part of Native.
         * Native ads may contain a video as the ad creative itself.
         */
        @SerializedName("video")
        var video: AssetVideo.Request? = null

        /**
         * Data object for brand name, description, ratings, prices etc.
         */
        @SerializedName("data")
        var data: AssetData.Request? = null

        /**
         * Placeholder for exchange-specific extensions to OpenRTB.
         */
        @field:SerializedName("ext")
        var extension: Any? = null
    }

    class Response {
        /**
         * Optional if assetsurl/dcourl is being used; required if embedded asset is being used.
         */
        @SerializedName("id")
        var id: Int? = null

        /**
         * Set to 1 if asset is required. (bidder requires it to be displayed).
         */
        @SerializedName("required")
        var required: Int = 0

        /**
         * Title object for title assets.
         */
        @SerializedName("title")
        var title: AssetTitle.Response? = null

        /**
         * Image object for image assets.
         */
        @SerializedName("img")
        var image: AssetImage.Response? = null

        /**
         * Video object for video assets. Note that in-stream (ie pre-roll, etc) video ads are not part of Native.
         * Native ads may contain a video as the ad creative itself.
         */
        @SerializedName("video")
        var video: AssetVideo.Response? = null

        /**
         * Data object for brand name, description, ratings, prices etc.
         */
        @SerializedName("data")
        var data: AssetData.Response? = null

        /**
         * Link object for call to actions. The link object applies if the asset item is activated (clicked).
         * If there is no link object on the asset, the parent link object on the bid response applies.
         */
        @SerializedName("link")
        var link: Link? = null

        /**
         * Placeholder for exchange-specific extensions to OpenRTB.
         */
        @field:SerializedName("ext")
        var extension: Any? = null
    }
}