package io.aiactiv.sdk.adnetwork.models.bid

import android.content.Context
import android.content.pm.PackageManager
import androidx.annotation.NonNull
import com.google.gson.annotations.SerializedName
import io.aiactiv.sdk.SingletonHolder
import io.aiactiv.sdk.internal.Exclude

class ApplicationInfo(@NonNull @Exclude val context: Context) {

    /**
     * Exchange-specific app ID.
     */
    @field:SerializedName("id")
    var id: String? = null

    /**
     * App name (may be aliased at the publisher’s request).
     */
    @field:SerializedName("name")
    var name: String? = null

    /**
     * A platform-specific application identifier intended to be unique
     * to the app and independent of the exchange.
     * On Android, this should be a bundle or package name (e.g., com.foo.game).
     * On iOS, it is typically a numeric ID.
     */
    @field:SerializedName("bundle")
    var bundle: String? = null

    /**
     * Domain of the app (e.g., “game.foo.com”).
     */
    @field:SerializedName("domain")
    var domain: String? = null

    /**
     * App store URL for an installed app; for IQG 2.1 compliance.
     */
    @field:SerializedName("storeurl")
    var storeUrl: String? = null

    /**
     * Application version.
     */
    @field:SerializedName("ver")
    var version: String? = null

    /**
     * Details about the [Publisher]  of the app.
     */
    @field:SerializedName("publisher")
    var publisher: Publisher? = null

    /**
     * Placeholder for exchange-specific extensions to OpenRTB.
     */
    @field:SerializedName("ext")
    private val extension: Extension

    init {
        val packageInfo = context.packageManager.getPackageInfo(
            context.packageName,
            PackageManager.GET_META_DATA
        )

        bundle = packageInfo.packageName
        version = packageInfo.versionName

        val applicationInfo = context.applicationInfo
        name = context.packageManager.getApplicationLabel(applicationInfo).toString()

        extension = Extension()
    }

    companion object: SingletonHolder<ApplicationInfo, Context>(::ApplicationInfo)

    class Extension {
        // @field:SerializedName("aicactus")
        // val aicactus = Aicactus.instances
    }
}