package io.aiactiv.sdk.adnetwork.api

import android.content.Context
import io.aiactiv.sdk.SingletonHolder
import io.aiactiv.sdk.adnetwork.models.container.Container
import io.aiactiv.sdk.internal.ApiResponse
import io.aiactiv.sdk.internal.Client
import io.aiactiv.sdk.internal.UriUtils

class CoreApiClient private constructor(val context: Context) {
    private val serviceHttpClient = Client.getInstance(context)

    fun init(containerId: String): ApiResponse<Container> {
        val uri = UriUtils.buildUri(
            Client.ADNETWORK_API_BASE_URI,
            BASE_PATH_CONTAINER_INIT,
            containerId,
        )
        return serviceHttpClient.get(uri, emptyMap(), emptyMap())
    }

    companion object: SingletonHolder<CoreApiClient, Context>(::CoreApiClient) {
        private const val BASE_PATH_CONTAINER_INIT = "container"
    }
}