package io.aiactiv.sdk.adnetwork.api

import androidx.annotation.NonNull
import com.google.gson.annotations.SerializedName
import io.aiactiv.sdk.adnetwork.models.bid.*

data class BidRequest(
    @field:SerializedName("id")
    @NonNull val id: String,
) {
    /**
     * Array of [Impression] objects representing the impressions offered.
     * At least 1 Imp object is required.
     */
    @field:SerializedName("imp")
    var impression: Array<Impression>? = null

    /**
     * Details via an [ApplicationInfo] object about the publisher’s app
     */
    @field:SerializedName("app")
    var app: ApplicationInfo? = null

    /**
     * Details via a [Device] object about the user’s device to which the impression will be delivered.
     */
    @field:SerializedName("device")
    var device: Device? = null

    /**
     * Details via a User object about the human user of the device; the advertising audience.
     */
    @field:SerializedName("user")
    var user: User? = null

    /**
     * Indicator of test mode in which auctions are not billable, where 0 = live mode, 1 = test mode.
     */
    @field:SerializedName("test")
    var test: Int? = null

    /**
     * Auction type, where 1 = First Price, 2 = Second Price Plus.
     * Exchange-specific auction types can be defined using values greater than 500.
     */
    @field:SerializedName("at")
    var auctionType: Int? = null

    /**
     * Maximum time in milliseconds the exchange allows for bids to be received including Internet latency to avoid timeout.
     * This value supersedes any a priori guidance from the exchange.
     */
    @field:SerializedName("tmax")
    var maximumTime: Int? = null

    /**
     * Whitelist of buyer seats (e.g., advertisers, agencies) allowed to bid on this deal.
     * IDs of seats and the buyer’s customers to which they refer must be coordinated between
     * bidders and the exchange a priori. Omission implies no seat restrictions.
     */
    @field:SerializedName("wseat")
    var whiteListSeatIDs: Array<String>? = null

    /**
     * Block list of buyer seats (e.g., advertisers, agencies) restricted from bidding on this impression.
     * IDs of seats and knowledge of the buyer’s customers to which they refer must be coordinated between
     * bidders and the exchange a priori. At most, only one of [whiteListSeatIDs] and [blockListSeatIDs]
     * should be used in the same request. Omission of both implies no seat restrictions.
     */
    @field:SerializedName("bseat")
    var blockListSeatIDs: Array<String>? = null

    /**
     * Flag to indicate if Exchange can verify that the impressions offered represent
     * all of the impressions available in context (e.g., all on the web page,
     * all video spots such as pre/mid/post roll) to support road-blocking.
     * 0 = no or unknown, 1 = yes, the impressions offered represent all that are available.
     */
    @field:SerializedName("allimps")
    var allImpressions: Int? = null

    /**
     * Array of allowed currencies for bids on this bid request using ISO-4217 alpha codes.
     * Recommended only if the exchange accepts multiple currencies.
     */
    @field:SerializedName("cur")
    var currencies: Array<String>? = null

    /**
     * White list of languages for creatives using ISO-639-1-alpha-2.
     * Omission implies no specific restrictions, but buyers would be advised to
     * consider language attribute in the [Device] and/or Content objects if available.
     */
    @field:SerializedName("wlang")
    var whiteListLanguages: Array<String>? = null

    /**
     * Blocked advertiser categories using the IAB content categories.
     */
    @field:SerializedName("bcat")
    var blockedCategories: Array<String>? = null

    /**
     * Block list of advertisers by their domains
     */
    @field:SerializedName("badv")
    var blockedAdvertiserDomains: Array<String>? = null

    /**
     * Block list of applications by their platform-specific exchange- independent application identifiers.
     * On Android, these should be bundle or package names (e.g., com.foo.game). On iOS, these are numeric IDs.
     */
    @field:SerializedName("bapp")
    var blockedApps: Array<String>? = null

    /**
     * A [Source] object that provides data about the inventory source and
     * which entity makes the final decision.
     */
    @field:SerializedName("source")
    var source: Source = Source()

    /**
     * A [Regs] object that specifies any industry, legal, or governmental regulations in force for this request.
     */
    @field:SerializedName("regs")
    var regs: Regs? = null

    /**
     * Placeholder for exchange-specific extensions to OpenRTB.
     */
    @field:SerializedName("ext")
    var extension: Map<String, Any>? = null
}