package io.aiactiv.sdk.adnetwork.ads

import android.content.Context
import android.util.Log
import io.aiactiv.sdk.adnetwork.api.ApiResult

class VideoAdLoader(
    context: Context,
    private val adUnitID: Int,
    private val adSize: AdSize?,
) {

    private var adViewController = AdViewController.getInstance(context)

    var listener: VideoAdListener? = null

    fun loadAd(adRequest: AdRequest) {
        adViewController.request(adUnitID, adSize, AdType.VIDEO, adRequest) { response ->
            when (response) {
                is ApiResult.Success<String> -> {
                    val adMarkup = response.data
                    listener?.onVideoAdLoaded(adUnitID, adMarkup)
                }
                else -> {
                    val error = (response as ApiResult.Error).error
                    val message = "Load Ad failed: ${error.getMessage()}"
                    Log.e("AdView", message)
                    listener?.onVideoAdFailedToLoad(adUnitID, message)
                }
            }
        }
    }

    companion object {
        inline fun build(context: Context, adUnitID: Int, adSize: AdSize, block: Builder.() -> Unit) =
            Builder(context, adUnitID, adSize).apply(block).build()
    }

    class Builder(
        private val context: Context,
        private val adUnitID: Int,
        private val adSize: AdSize?,
    ) {
        fun build() = VideoAdLoader(context, adUnitID, adSize)
    }
}