package io.aiactiv.sdk.adnetwork.ads

enum class AdSize(var width: Int, var height: Int) {
    BANNER(320, 50),
    FULL_BANNER(468, 60),
    LARGE_BANNER(320, 100),
    RECTANGLE(250, 250),
    MEDIUM_RECTANGLE(300, 250),
    VIDEO(480, 360),
    TEST(400, 100);

    companion object {
        fun forCustomVideo(width: Int, height: Int) = valueOf("VIDEO").apply {
            this.width = if (width > 0) width else 480
            this.height = if (height > 0) height else 360
        }

        fun forCustomBanner(width: Int, height: Int) = valueOf("BANNER").apply {
            this.width = if (width > 0) width else 320
            this.height = if (height > 0) height else 50
        }
    }
}