package io.aiactiv.sdk.adnetwork.ads

import java.util.*

class AdRequest(val context: Map<String, Any>?) {

    val id: String = UUID.randomUUID().toString()

    private constructor(builder: Builder) : this(builder.context)

    companion object {
        inline fun build(block: Builder.() -> Unit) = Builder().apply(block).build()
    }

    class Builder {
        var context: Map<String, Any>? = null
        fun build() = AdRequest(this)
    }
}