package io.aiactiv.sdk

import io.aiactiv.sdk.internal.ValueMap

class Properties: ValueMap {

    constructor(): super()
    constructor(delegate: MutableMap<String, Any?>): super(delegate)
    constructor(initialCapacity: Int): super(initialCapacity)

    override fun putValue(key: String, value: Any?): Properties {
        super.putValue(key, value)
        return this
    }

    /**
     * Set the referrer that led the user to the screen. In the browser it is the document.referrer
     * property.
     *
     * @see [Page Properties](https://segment.com/docs/api/tracking/page/.properties)
     */
    fun putReferrer(referrer: String): Properties {
        return putValue(REFERRER_KEY, referrer)
    }

    fun referrer(): String? {
        return getString(REFERRER_KEY)
    }

    companion object {
        // Common Properties
        private const val REVENUE_KEY = "revenue"
        private const val CURRENCY_KEY = "currency"
        private const val VALUE_KEY = "value"

        // Screen Properties
        private const val PATH_KEY = "path"
        private const val REFERRER_KEY = "referrer"
        private const val TITLE_KEY = "title"
        private const val URL_KEY = "url"

        // Ecommerce API
        private const val NAME_KEY = "name" // used by product too

        private const val CATEGORY_KEY = "category"
        private const val SKU_KEY = "sku"
        private const val PRICE_KEY = "price"
        private const val ID_KEY = "id"
        private const val ORDER_ID_KEY = "orderId"
        private const val TOTAL_KEY = "total"
        private const val SUBTOTAL_KEY = "subtotal"
        private const val SHIPPING_KEY = "shipping"
        private const val TAX_KEY = "tax"
        private const val DISCOUNT_KEY = "discount"
        private const val COUPON_KEY = "coupon"
        private const val PRODUCTS_KEY = "products"
        private const val REPEAT_KEY = "repeat"
    }
}