package io.aiactiv.sdk

import android.content.Context
import io.aiactiv.sdk.internal.Cartographer
import io.aiactiv.sdk.internal.ValueMap

class ProjectSettings(map: MutableMap<String, Any?>): ValueMap(map) {

    fun timestamp() = getLong(TIMESTAMP_KEY, 0)

    fun plan() = getValueMap(PLAN_KEY)

    fun trackingPlan(): ValueMap? = plan()?.getValueMap(TRACKING_PLAN_KEY)

    fun integrations(): ValueMap? = getValueMap(INTEGRATIONS_KEY)

    fun edgeFunctions(): ValueMap? = getValueMap(EDGE_FUNCTIONS_KEY)

    companion object {
        private const val TIMESTAMP_KEY = "timestamp"
        private const val PLAN_KEY = "plan"
        private const val INTEGRATIONS_KEY = "integrations"
        private const val TRACKING_PLAN_KEY = "track"
        private const val EDGE_FUNCTIONS_KEY = "edgeFunction"

        fun create(map: MutableMap<String, Any?>): ProjectSettings {
            map[TIMESTAMP_KEY] = System.currentTimeMillis()
            return ProjectSettings(map)
        }
    }

    class Cache(
        context: Context,
        cartographer: Cartographer,
        tag: String,
    ): ValueMap.Cache<ProjectSettings>(context, cartographer, PROJECT_SETTINGS_CACHE_KEY_PREFIX + tag, tag, ProjectSettings::class.java) {

        override fun create(map: MutableMap<String, Any?>): ProjectSettings {
            return ProjectSettings(map)
        }

        companion object {
            private const val PROJECT_SETTINGS_CACHE_KEY_PREFIX = "project-settings-plan-"
        }
    }
}