package io.aiactiv.sdk

import io.aiactiv.sdk.analytics.AiactivIntegration
import java.util.concurrent.ConcurrentHashMap

class Options(
    val integrations: MutableMap<String, Any> = ConcurrentHashMap(),
    val context: MutableMap<String, Any> = ConcurrentHashMap(),
) {
    fun setIntegration(integrationKey: String, enabled: Boolean): Options {
        if (AiactivIntegration.AIACTIV_KEY == integrationKey) {
            throw IllegalArgumentException("Aiactiv integration cannot be enabled or disabled.")
        }
        integrations[integrationKey] = enabled
        return this
    }

    fun setIntegrationOptions(integrationKey: String, options: Map<String, Any>): Options {
        integrations[integrationKey] = options
        return this
    }

    fun putContext(key: String, value: Any): Options {
        context[key] = value
        return this
    }

    fun integrations(): Map<String, Any> {
        return LinkedHashMap(integrations)
    }

    fun context(): Map<String, Any> {
        return LinkedHashMap(context)
    }

    companion object {
        const val ALL_INTEGRATIONS_KEY = "All"
    }
}