package io.aiactiv.sdk

import io.aiactiv.sdk.analytics.integrations.BasePayload

class MiddleChainRunner(
    private val  index: Int,
    private val payload: BasePayload,
    private val middlewares: List<Middleware>,
    private val callback: Middleware.Callback,
): Middleware.Chain {

    override fun payload(): BasePayload {
        return payload
    }

    override fun proceed(payload: BasePayload) {
        if (index < middlewares.size) {
            val chain = MiddleChainRunner(index + 1, payload, middlewares, callback)
            middlewares[index].intercept(chain)
            return
        }

        callback.invoke(payload)
    }
}