package io.aiactiv.sdk

import android.content.Context
import android.util.Log
import io.aiactiv.sdk.adnetwork.api.CoreApiClient
import io.aiactiv.sdk.adnetwork.models.bid.ApplicationInfo
import io.aiactiv.sdk.adnetwork.models.bid.Device
import io.aiactiv.sdk.adnetwork.models.container.Container
import io.aiactiv.sdk.internal.CappingManager
import kotlinx.coroutines.*

class AdNetwork(val context: Context) {

    private var container: Container? = null
    private val device = Device.getInstance(context)
    private val app = ApplicationInfo.getInstance(context)
    private val cappingManager = CappingManager.getInstance(context)

    fun initialize(writeKey: String) {
        CoroutineScope(Dispatchers.IO).launch {
            val coreApiClient = CoreApiClient.getInstance(context)
            val result = coreApiClient.init(writeKey)
            result.responseData?.let { container ->
                this@AdNetwork.container = container
                this@AdNetwork.container?.configurationID = writeKey

                this@AdNetwork.cappingManager.config = container.capping
                return@launch
            }
            result.errorData.getMessage().let { message ->
                if (message.isNotEmpty()) {
                    Log.e(TAG, "Couldn't init container. Error: $message")
                }
            }
        }
    }

    fun container() = this.container
    fun device() = this.device
    fun app() = this.app
    fun capping() = this.cappingManager

    companion object: SingletonHolder<AdNetwork, Context>(::AdNetwork) {
        private val TAG = AdNetwork::class.simpleName
    }
}