/*
 * Decompiled with CFR 0.152.
 */
package io.agistep.event;

import io.agistep.aggregator.IdUtils;
import io.agistep.event.Event;
import io.agistep.event.EventHolder;
import io.agistep.event.ThreadLocalEventSeqHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

class ThreadLocalEventHolder
implements EventHolder {
    private static final ThreadLocal<List<Event>> changes = ThreadLocal.withInitial(() -> Collections.synchronizedList(new ArrayList()));
    private static final ThreadLocal<Map<Long, Long>> changes2 = ThreadLocal.withInitial(HashMap::new);

    static EventHolder instance() {
        return new ThreadLocalEventHolder();
    }

    private ThreadLocalEventHolder() {
    }

    @Override
    public List<Event> getEventAll() {
        return ThreadLocalEventHolder.isEmpty(changes.get()) ? List.of() : Collections.unmodifiableList(changes.get());
    }

    @Override
    public void hold(Event anEvent) {
        List<Event> events = changes.get();
        events.add(anEvent);
        ThreadLocalEventHolder.updateSeq(anEvent.getAggregateId(), anEvent.getSeq());
    }

    private static boolean isEmpty(List<Event> events) {
        return events == null || events.isEmpty();
    }

    @Override
    public List<Event> getEvents(Object aggregate) {
        if (IdUtils.notAssignedIdOf(aggregate)) {
            return List.of();
        }
        Long idValue = IdUtils.idOf(aggregate);
        return this.getEventAll().stream().filter(e -> Objects.equals(idValue, e.getAggregateId())).collect(Collectors.toList());
    }

    @Override
    public void clearAll() {
        changes.remove();
        ThreadLocalEventSeqHolder.instance().clearAll();
    }

    @Override
    public void clear(Object aggregate) {
        long id = IdUtils.idOf(aggregate);
        List<Event> events = changes.get().stream().filter(e -> e.getAggregateId() == id).toList();
        List remained = changes.get().stream().filter(e -> !events.contains(e)).collect(Collectors.toList());
        changes.set(remained);
        ThreadLocalEventSeqHolder.instance().clear(aggregate);
    }

    private static void updateSeq(long aggregateId, long seq) {
        ThreadLocalEventSeqHolder.instance().setSeq(aggregateId, seq);
    }
}

