/*
 * Decompiled with CFR 0.152.
 */
package io.agistep.event;

import io.agistep.event.Event;
import io.agistep.event.EventHandlerAdapterInitializerImpl;
import io.agistep.event.EventHandlerAdapterRetriever;
import io.agistep.event.EventHandlerAdapterRetrieverImpl;
import io.agistep.event.EventHandlerMethodAdapter;
import io.agistep.event.EventHandlerMethodAdapterLoader;
import io.agistep.event.EventHandlerMethodScannerImpl;
import io.agistep.event.ThreadLocalEventSeqHolder;
import io.agistep.utils.BasePackageLoader;
import java.util.List;

final class EventReplayer {
    private static EventHandlerAdapterRetriever eventHandlerAdapterRetriever;

    EventReplayer() {
    }

    static void replay(Object aggregate, Event anEvent) {
        EventReplayer.validate(aggregate, anEvent);
        String payloadName = anEvent.getPayload().getClass().getName();
        EventHandlerMethodAdapter handler = eventHandlerAdapterRetriever.retrieve(payloadName);
        handler.handle(aggregate, anEvent);
        EventReplayer.updateSeq(anEvent.getAggregateId(), anEvent.getSeq());
    }

    private static void validate(Object aggregate, Event anEvent) {
        if (anEvent == null) {
            throw new IllegalArgumentException("event should not be null");
        }
        if (aggregate == null) {
            throw new IllegalArgumentException("aggregate should not be null");
        }
    }

    private static void updateSeq(long aggregateId, long seq) {
        ThreadLocalEventSeqHolder.instance().setSeq(aggregateId, seq);
    }

    static {
        EventHandlerMethodAdapterLoader eventHandlerMethodLoader = new EventHandlerMethodAdapterLoader(new EventHandlerMethodScannerImpl(), new EventHandlerAdapterInitializerImpl());
        List<EventHandlerMethodAdapter> adapters = eventHandlerMethodLoader.load(BasePackageLoader.load());
        eventHandlerAdapterRetriever = new EventHandlerAdapterRetrieverImpl(adapters);
    }
}

