/*
 * Decompiled with CFR 0.152.
 */
package io.agistep.event;

import io.agistep.aggregator.IdUtils;
import io.agistep.event.Event;
import io.agistep.event.ThreadLocalEventSeqHolder;
import java.time.LocalDateTime;
import java.util.Objects;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.valid4j.Assertive;
import org.valid4j.Validation;

public class EventMaker {
    static Event make(Object aggregate, Object payload) {
        long nextSeq;
        long aggregateId;
        long eventId = IdUtils.gen();
        if (IdUtils.notAssignedIdOf(aggregate)) {
            aggregateId = IdUtils.gen();
            nextSeq = 0L;
        } else {
            aggregateId = IdUtils.idOf(aggregate);
            nextSeq = EventMaker.nextSeq(aggregateId);
        }
        return EventMaker.make(eventId, aggregateId, nextSeq, payload.getClass().getName(), LocalDateTime.now(), payload);
    }

    private static long nextSeq(Object aggregateId) {
        return ThreadLocalEventSeqHolder.instance().nextSeq((Long)aggregateId);
    }

    public static Event make(long eventId, long aggregateId, long nextSeq, String eventName, LocalDateTime occurredAt, Object payload) {
        return EventBuilder.builder().id(eventId).name(eventName).aggregateId(aggregateId).seq(nextSeq).payload(payload).occurredAt(occurredAt).build();
    }

    public static Object payload(Object payload) {
        return payload;
    }

    public static String eventName(String name) {
        return name;
    }

    public static LocalDateTime occurredAt(LocalDateTime dateTime) {
        return dateTime;
    }

    public static long seq(long seq) {
        return seq;
    }

    public static long aggregateId(long id) {
        return id;
    }

    public static long eventId(long id) {
        return id;
    }

    private static final class EventBuilder {
        private Long id;
        private String name;
        private Long seq;
        private Long aggregateId;
        private Object payload;
        private LocalDateTime occurredAt;

        private EventBuilder() {
        }

        public static EventBuilder builder() {
            return new EventBuilder();
        }

        public Event build() {
            Validation.validate((boolean)this.name.equals(this.payload.getClass().getName()), (Exception)new IllegalArgumentException("Event name should be same with payload class name."));
            if (this.occurredAt == null) {
                this.occurredAt(LocalDateTime.now());
            }
            return new ObjectPayloadEnvelop((Long)Assertive.require((Object)this.id, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()))), this.name, this.seq, this.aggregateId, this.payload, this.occurredAt);
        }

        public EventBuilder name(String name) {
            this.name = name;
            return this;
        }

        public EventBuilder id(long id) {
            this.id = id;
            return this;
        }

        public EventBuilder seq(long seq) {
            this.seq = seq;
            return this;
        }

        public EventBuilder aggregateId(Long aggregateId) {
            this.aggregateId = aggregateId;
            return this;
        }

        public EventBuilder payload(Object payload) {
            this.payload = payload;
            return this;
        }

        public EventBuilder occurredAt(LocalDateTime occurredAt) {
            this.occurredAt = occurredAt;
            return this;
        }
    }

    private static class ObjectPayloadEnvelop
    implements Event {
        private final long id;
        private final String name;
        private final long seq;
        private final Long aggregateId;
        private final Object payload;
        private final LocalDateTime occurredAt;

        private ObjectPayloadEnvelop(long id, String name, long seq, Long aggregateId, Object payload, LocalDateTime occurredAt) {
            this.id = id;
            this.name = name;
            this.seq = seq;
            this.aggregateId = aggregateId;
            this.payload = payload;
            this.occurredAt = occurredAt;
        }

        @Override
        public long getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public long getSeq() {
            return this.seq;
        }

        @Override
        public long getAggregateId() {
            return this.aggregateId;
        }

        @Override
        public Object getPayload() {
            return this.payload;
        }

        @Override
        public LocalDateTime getOccurredAt() {
            return this.occurredAt;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ObjectPayloadEnvelop that = (ObjectPayloadEnvelop)o;
            return this.seq == that.seq && Objects.equals(this.aggregateId, that.aggregateId) && Objects.equals(this.name, that.name) && Objects.equals(this.payload, that.payload) && Objects.equals(this.occurredAt, that.occurredAt);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.seq, this.aggregateId, this.payload, this.occurredAt);
        }

        public String toString() {
            return "ObjectPayloadEnvelop{id=" + this.id + ", name='" + this.name + "', seq=" + this.seq + ", aggregateId=" + this.aggregateId + ", payload=" + this.payload + ", occurredAt=" + this.occurredAt + "}";
        }
    }
}

